<?php

namespace App\ApiResource;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use App\State\AddressProvider;

#[ApiResource(
    operations: [
        // Récupérer les municipalités(communes) selon postal code
        new GetCollection(
            uriTemplate: '/fetchMunicipalities', // Définit l'URL pour l'api
            name: 'fetch-municipalities', // Nom de l'opération
            provider: AddressProvider::class,  // Le provider (fournisseur de données) utilisé pour cette opération
            paginationEnabled: false, // Désactive la pagination pour cette opération
            openapiContext: [
                'parameters' => [
                    [
                        'in' => 'query',  // Paramètre à passer dans la query string de l'URL
                        'name' => 'postalCode', // Nom du paramètre attendu
                        'schema' => [
                            'type' => 'string',
                            'required' => true
                        ]
                    ],
                ]
            ],
            formats: 'json'  // Le format de réponse est JSON
        ),
        new GetCollection(
            uriTemplate: '/fetchAddress', // Définit l'URL pour l'api
            formats: 'json', // Nom de l'opération
            openapiContext: [
                'parameters' => [ // Paramètres de la requête  à passer dans la query string de l'URL
                    [
                        'in' => 'query',
                        'name' => 'q',
                        'schema' => [
                            'type' => 'string',
                            'required' => false
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'postalCode',
                        'schema' => [
                            'type' => 'string',
                            'required' => true
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'cityCode',
                        'schema' => [
                            'type' => 'string',
                            'required' => true
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'trackNumber',
                        'schema' => [
                            'type' => 'string',
                            'required' => false
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'limit', //limiter le nombre de résultats retournées par l'api min 5 max 100.
                        'schema' => [
                            'type' => 'integer'
                        ]
                    ]
                ]
            ], // Le provider (fournisseur de données) utilisé pour cette opération
            paginationEnabled: false,
            name: 'fetch-address',
            provider: AddressProvider::class
        ),
        new GetCollection(
            uriTemplate: '/fetchMunicipalitiesNew', // Définit l'URL pour l'api
            name: 'fetch-municipalities-new', // Nom de l'opération
            provider: AddressProvider::class,  // Le provider (fournisseur de données) utilisé pour cette opération
            paginationEnabled: false, // Désactive la pagination pour cette opération
            openapiContext: [
                'parameters' => [
                    [
                        'in' => 'query',  // Paramètre à passer dans la query string de l'URL
                        'name' => 'postalCode', // Nom du paramètre attendu
                        'schema' => [
                            'type' => 'string',
                            'required' => true
                        ]
                    ],
                ]
            ],
            formats: 'json'  // Le format de réponse est JSON
        ),
        new GetCollection(
            uriTemplate: '/fetchAddressNew', // Définit l'URL pour l'api
            formats: 'json', // Nom de l'opération
            openapiContext: [
                'parameters' => [ // Paramètres de la requête  à passer dans la query string de l'URL
                    [
                        'in' => 'query',
                        'name' => 'q',
                        'schema' => [
                            'type' => 'string',
                            'required' => false
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'postalCode',
                        'schema' => [
                            'type' => 'string',
                            'required' => true
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'cityCode',
                        'schema' => [
                            'type' => 'string',
                            'required' => true
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'trackNumber',
                        'schema' => [
                            'type' => 'string',
                            'required' => false
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'limit', //limiter le nombre de résultats retournées par l'api min 5 max 100.
                        'schema' => [
                            'type' => 'integer',
                            'required' => true
                        ]
                    ]
                ]
            ], // Le provider (fournisseur de données) utilisé pour cette opération
            paginationEnabled: false,
            name: 'fetch-address-new',
            provider: AddressProvider::class
        ),
        new GetCollection(
            uriTemplate: '/fetchTrackNumber', // Définit l'URL pour l'api
            formats: 'json', // Nom de l'opération
            openapiContext: [
                'parameters' => [ // Paramètres de la requête  à passer dans la query string de l'URL
                    [
                        'in' => 'query',
                        'name' => 'postalCode',
                        'schema' => [
                            'type' => 'string',
                            'required' => true
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'cityCode',
                        'schema' => [
                            'type' => 'string',
                            'required' => true
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'trackName',
                        'schema' => [
                            'type' => 'string',
                            'required' => false
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'limit', //limiter le nombre de résultats retournées par l'api min 5 max 100.
                        'schema' => [
                            'type' => 'integer',
                            'required' => true
                        ]
                    ]
                ]
            ], // Le provider (fournisseur de données) utilisé pour cette opération
            paginationEnabled: false,
            name: 'fetch-track-number',
            provider: AddressProvider::class
        ),
        new GetCollection(
            uriTemplate: '/fetch-full-address', // Définit l'URL pour l'api
            formats: 'json', // Nom de l'opération
            openapiContext: [
                'parameters' => [ // Paramètres de la requête  à passer dans la query string de l'URL
                    [
                        'in' => 'query',
                        'name' => 'address',
                        'schema' => [
                            'type' => 'string',
                            'required' => false
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'limit', //limiter le nombre de résultats retournées par l'api min 5 max 100.
                        'schema' => [
                            'type' => 'integer',
                            'required' => true
                        ]
                    ]
                ]
            ], // Le provider (fournisseur de données) utilisé pour cette opération
            paginationEnabled: false,
            name: 'fetch-full-address',
            provider: AddressProvider::class
        ),
    ]
)]
class Address {}
