<?php

namespace App\ApiResource;

use ApiPlatform\Metadata\GetCollection;
use App\State\InseeRefStateProvider;
use ApiPlatform\Metadata\ApiResource;

#[ApiResource(
    operations: [
        new GetCollection(
            uriTemplate: 'fetch/insee/data',
            name: 'fetch-Insee-data',
            provider: InseeRefStateProvider::class,
            paginationEnabled: true, //  Pagination activée
            paginationItemsPerPage: 10, //  10 éléments par page par défaut
            paginationClientEnabled: true, //  Permet au client de changer itemsPerPage
            paginationClientItemsPerPage: true, //  Permet itemsPerPage dans la query
            openapiContext: [
                'parameters' => [
                    [
                        'in' => 'query',
                        'name' => 'BirthDate',
                        'schema' => [
                            'type' => 'string',
                            'required' => false
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'label',
                        'schema' => [
                            'type' => 'string',
                            'required' => false
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'page',
                        'schema' => [
                            'type' => 'integer',
                            'default' => 1
                        ]
                    ],
                    [
                        'in' => 'query',
                        'name' => 'itemsPerPage',
                        'schema' => [
                            'type' => 'integer',
                            'default' => 10
                        ]
                    ]
                ]
            ],
            formats: 'json'
        ),
    ]
)]
class Insee {}
