<?php

namespace App\ApiResource;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\Get;
use App\State\SirenProvider;

#[ApiResource(
    operations: [
        // Déclarer une opération GET pour récupérer les informations d'une société à patir une api
        new Get(
            uriTemplate: '/fetchSociety', // Définit l'URL pour accéder à cette api
            name: 'fetch-society', // Nom de l'opération
            provider: SirenProvider::class, // Spécifie le fournisseur de données utilisé pour cette opération
            openapiContext: [ // Contexte OpenAPI pour la documentation
                'parameters' => [ // Paramètres acceptés dans la requête
                    [
                        'in' => 'query',  // Paramètre passé dans la query string de l'URL
                        'name' => 'siren',
                        'schema' => [
                            'type' => 'string',
                            'required' => true
                        ]
                    ],
                ]
            ],
            formats: 'json' // Le format de la réponse est JSON
        ),
    ]
)]
class Siren
{

    // Cette classe représente une ressource API pour récupérer des informations sur une société
    // via son numéro SIREN. Elle expose une opération GET avec un fournisseur de données.

}