<?php

namespace App\Entity;

use ApiPlatform\Metadata\Get;
use App\State\AddressProvider;
use Doctrine\ORM\Mapping\Index;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Metadata\ApiResource;
use App\Repository\AddressRepository;

#[ApiResource(
    operations: [
        new Get(
            uriTemplate: 'find/lat-long', // URI pour récupérer la liste des entities
            formats: ['json'],
            openapiContext: [
                'parameters' => [
                    [
                        'name' => 'codePostal',
                        'in' => 'query',
                        'required' => false,
                        'schema' => [
                            'type' => 'string',
                        ],
                    ],
                    [
                        'name' => 'nomVoie',
                        'in' => 'query',
                        'required' => false,
                        'schema' => [
                            'type' => 'string',
                        ],
                    ],
                    [
                        'name' => 'numero',
                        'in' => 'query',
                        'required' => false,
                        'schema' => [
                            'type' => 'integer',
                        ],
                    ],
                ]
            ],
            paginationEnabled: false, // Pagination désactivée
            deserialize: false, // Ne pas désérialiser le corps de la requête
            name: 'find-lat-long',
            provider: AddressProvider::class, // Fournisseur pour gérer la logique
        ),
    ]
)]
#[ORM\Entity(repositoryClass: AddressRepository::class)]
#[Index(name: "idx_numero", columns: ["numero"])]
#[Index(name: "idx_nom_voie", columns: ["nom_voie"])]
#[Index(name: "idx_code_postal", columns: ["code_postal"])]
#[Index(name: "idx_code_insee", columns: ["code_insee"])]
#[Index(name: "idx_nom_commune", columns: ["nom_commune"])]
#[Index(name: "lat", columns: ["lat"])]
#[Index(name: "lon", columns: ["lon"])]

class Address
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: 'integer')]
    private ?int $id = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $idAddr = null;


    #[ORM\Column(length: 255, nullable: true)]
    private ?string $idFantoir = null;

    #[ORM\Column(nullable: true)]
    private ?int $numero = null;

    #[ORM\Column(length: 10, nullable: true)]
    private ?string $rep = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nomVoie = null;

    #[ORM\Column(length: 10, nullable: true)]
    private ?string $codePostal = null;

    #[ORM\Column(length: 10, nullable: true)]
    private ?string $codeInsee = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nomCommune = null;

    #[ORM\Column(length: 10, nullable: true)]
    private ?string $codeInseeAncienneCommune = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nomAncienneCommune = null;

    #[ORM\Column(type: 'float', nullable: true)]
    private ?float $x = null;

    #[ORM\Column(type: 'float', nullable: true)]
    private ?float $y = null;

    #[ORM\Column(type: 'float', nullable: true)]
    private ?float $lon = null;

    #[ORM\Column(type: 'float', nullable: true)]
    private ?float $lat = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $typePosition = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $alias = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nomLd = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $libelleAcheminement = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nomAfnor = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $sourcePosition = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $sourceNomVoie = null;

    #[ORM\Column(type: 'boolean', nullable: true)]
    private ?bool $certificationCommune = null;

    #[ORM\Column(type: 'text', nullable: true)]
    private ?string $cadParcelles = null;

    #[ORM\Column(length: 36, nullable: true)]
    private ?string $idBanAdresse = null;

    #[ORM\Column(length: 36, nullable: true)]
    private ?string $idBanToponyme = null;

    #[ORM\Column(length: 36, nullable: true)]
    private ?string $idBanCommune = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getIdFantoir(): ?string
    {
        return $this->idFantoir;
    }

    public function getIdAddr(): ?string
    {
        return $this->idAddr;
    }

    public function setIdAddr(?string $idAddr): static
    {
        $this->idAddr = $idAddr;

        return $this;
    }


    public function setIdFantoir(?string $idFantoir): self
    {
        $this->idFantoir = $idFantoir;
        return $this;
    }

    public function getNumero(): ?int
    {
        return $this->numero;
    }

    public function setNumero(?int $numero): self
    {
        $this->numero = $numero;
        return $this;
    }

    public function getRep(): ?string
    {
        return $this->rep;
    }

    public function setRep(?string $rep): self
    {
        $this->rep = $rep;
        return $this;
    }

    public function getNomVoie(): ?string
    {
        return $this->nomVoie;
    }

    public function setNomVoie(?string $nomVoie): self
    {
        $this->nomVoie = $nomVoie;
        return $this;
    }

    public function getCodePostal(): ?string
    {
        return $this->codePostal;
    }

    public function setCodePostal(?string $codePostal): self
    {
        $this->codePostal = $codePostal;
        return $this;
    }

    public function getCodeInsee(): ?string
    {
        return $this->codeInsee;
    }

    public function setCodeInsee(?string $codeInsee): self
    {
        $this->codeInsee = $codeInsee;
        return $this;
    }

    public function getNomCommune(): ?string
    {
        return $this->nomCommune;
    }

    public function setNomCommune(?string $nomCommune): self
    {
        $this->nomCommune = $nomCommune;
        return $this;
    }

    public function getCodeInseeAncienneCommune(): ?string
    {
        return $this->codeInseeAncienneCommune;
    }

    public function setCodeInseeAncienneCommune(?string $codeInseeAncienneCommune): self
    {
        $this->codeInseeAncienneCommune = $codeInseeAncienneCommune;
        return $this;
    }

    public function getNomAncienneCommune(): ?string
    {
        return $this->nomAncienneCommune;
    }

    public function setNomAncienneCommune(?string $nomAncienneCommune): self
    {
        $this->nomAncienneCommune = $nomAncienneCommune;
        return $this;
    }

    public function getX(): ?float
    {
        return $this->x;
    }

    public function setX(?float $x): self
    {
        $this->x = $x;
        return $this;
    }

    public function getY(): ?float
    {
        return $this->y;
    }

    public function setY(?float $y): self
    {
        $this->y = $y;
        return $this;
    }

    public function getLon(): ?float
    {
        return $this->lon;
    }

    public function setLon(?float $lon): self
    {
        $this->lon = $lon;
        return $this;
    }

    public function getLat(): ?float
    {
        return $this->lat;
    }

    public function setLat(?float $lat): self
    {
        $this->lat = $lat;
        return $this;
    }

    public function getTypePosition(): ?string
    {
        return $this->typePosition;
    }

    public function setTypePosition(?string $typePosition): self
    {
        $this->typePosition = $typePosition;
        return $this;
    }

    public function getAlias(): ?string
    {
        return $this->alias;
    }

    public function setAlias(?string $alias): self
    {
        $this->alias = $alias;
        return $this;
    }

    public function getNomLd(): ?string
    {
        return $this->nomLd;
    }

    public function setNomLd(?string $nomLd): self
    {
        $this->nomLd = $nomLd;
        return $this;
    }

    public function getLibelleAcheminement(): ?string
    {
        return $this->libelleAcheminement;
    }

    public function setLibelleAcheminement(?string $libelleAcheminement): self
    {
        $this->libelleAcheminement = $libelleAcheminement;
        return $this;
    }

    public function getNomAfnor(): ?string
    {
        return $this->nomAfnor;
    }

    public function setNomAfnor(?string $nomAfnor): self
    {
        $this->nomAfnor = $nomAfnor;
        return $this;
    }

    public function getSourcePosition(): ?string
    {
        return $this->sourcePosition;
    }

    public function setSourcePosition(?string $sourcePosition): self
    {
        $this->sourcePosition = $sourcePosition;
        return $this;
    }

    public function getSourceNomVoie(): ?string
    {
        return $this->sourceNomVoie;
    }

    public function setSourceNomVoie(?string $sourceNomVoie): self
    {
        $this->sourceNomVoie = $sourceNomVoie;
        return $this;
    }

    public function getCertificationCommune(): ?bool
    {
        return $this->certificationCommune;
    }

    public function setCertificationCommune(?bool $certificationCommune): self
    {
        $this->certificationCommune = $certificationCommune;
        return $this;
    }

    public function getCadParcelles(): ?string
    {
        return $this->cadParcelles;
    }

    public function setCadParcelles(?string $cadParcelles): self
    {
        $this->cadParcelles = $cadParcelles;
        return $this;
    }

    public function getIdBanAdresse(): ?string
    {
        return $this->idBanAdresse;
    }

    public function setIdBanAdresse(?string $idBanAdresse): self
    {
        $this->idBanAdresse = $idBanAdresse;
        return $this;
    }

    public function getIdBanToponyme(): ?string
    {
        return $this->idBanToponyme;
    }

    public function setIdBanToponyme(?string $idBanToponyme): self
    {
        $this->idBanToponyme = $idBanToponyme;
        return $this;
    }

    public function getIdBanCommune(): ?string
    {
        return $this->idBanCommune;
    }

    public function setIdBanCommune(?string $idBanCommune): self
    {
        $this->idBanCommune = $idBanCommune;
        return $this;
    }
}
