<?php

namespace App\Entity;

use App\Repository\InseeRefRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: InseeRefRepository::class)]
#[ORM\Index(name: "fulltext_inseeCodeName", columns: ["insee_code_name"], flags: ["fulltext"])]
class InseeRef
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 10, nullable: true)]
    private ?string $inseeCode = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $inseeName = null;

    #[ORM\Column(type: Types::DATE_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $municipalityStartDate = null;

    #[ORM\Column(type: Types::DATE_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $municipalityEndDate = null;

    #[ORM\Column(length: 120, nullable: true)]
    private ?string $inseeCodeName = null;

    #[ORM\ManyToOne(inversedBy: 'inseeRefs')]
    private ?Department $department = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getInseeCode(): ?string
    {
        return $this->inseeCode;
    }

    public function setInseeCode(string $inseeCode): static
    {
        $this->inseeCode = $inseeCode;

        return $this;
    }

    public function getInseeName(): ?string
    {
        return $this->inseeName;
    }

    public function setInseeName(?string $inseeName): static
    {
        $this->inseeName = $inseeName;

        return $this;
    }

    public function getMunicipalityStartDate(): ?\DateTimeInterface
    {
        return $this->municipalityStartDate;
    }

    public function setMunicipalityStartDate(?\DateTimeInterface $municipalityStartDate): static
    {
        $this->municipalityStartDate = $municipalityStartDate;

        return $this;
    }

    public function getMunicipalityEndDate(): ?\DateTimeInterface
    {
        return $this->municipalityEndDate;
    }

    public function setMunicipalityEndDate(\DateTimeInterface $municipalityEndDate): static
    {
        $this->municipalityEndDate = $municipalityEndDate;

        return $this;
    }

    public function getInseeCodeName(): ?string
    {
        return $this->inseeCodeName;
    }

    public function setInseeCodeName(?string $inseeCodeName): static
    {
        $this->inseeCodeName = $inseeCodeName;

        return $this;
    }

    public function getDepartment(): ?Department
    {
        return $this->department;
    }

    public function setDepartment(?Department $department): static
    {
        $this->department = $department;

        return $this;
    }
}
