<?php

namespace App\Entity;

use ApiPlatform\Metadata\Get;
use App\State\AddressProvider;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping\Index;
use Doctrine\ORM\Mapping as ORM;
use App\Repository\RppsRepository;
use ApiPlatform\Metadata\ApiFilter;
use ApiPlatform\Metadata\ApiResource;
use App\State\DepartmentStateProvider;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\Doctrine\Orm\Filter\OrderFilter;
use App\State\RppsProvider;
use Symfony\Component\Serializer\Attribute\Groups;

#[ORM\Entity(repositoryClass: RppsRepository::class)]
// des Index pour optimiser la recherche
#[Index(name: "search_id", columns: ["id"])]
#[Index(name: "search_profession_code", columns: ["profession_code"])]
#[Index(name: "search_national_identifiant", columns: ["pp_national_identification"])]
#[Index(name: "search_firstname", columns: ["firstname_exercise"])]
#[Index(name: "search_lastname", columns: ["exercise_name"])]
#[Index(name: "search_fullname", columns: ["ps_fullname"])]
#[Index(name: "search_profession_label", columns: ["profession_label"])]
#[Index(name: "search_professional_category_code", columns: ["professional_category_code"])]
#[Index(name: "search_sepeciality_code", columns: ["know_how_code"])]
#[Index(name: "search_speciality", columns: ["know_how_label"])]
#[Index(name: "search_postal_code", columns: ["postal_code_cs"])]
#[Index(name: "search_country", columns: ["country_label_cs"])]
#[Index(name: "search_country_label", columns: ["country_label_cs"])]
#[Index(name: "search_phone_number_1", columns: ["phone_number_cs"])]
#[Index(name: "search_mail_cs", columns: ["mail_cs"])]
#[Index(name: "search_address_bal_mssante", columns: ["address_bal_mssante"])]
#[Index(name: "search_addr", columns: ["addr"])]
#[Index(name: "search_municipality", columns: ["municipality_label_cs"])]
#[Index(name: "search_department", columns: ["department"])]
#[
    ApiResource(  // Déclaration de l'entité comme ressource API
        operations: [
            new GetCollection( // Opération pour récupérer une collection de professionnels de santé
                uriTemplate: '/ps/list', // Nom de l'opération
                formats: 'json', // URL pour accéder à cette opération
                paginationEnabled: true,
                paginationItemsPerPage: 10,
                paginationClientItemsPerPage: true, // Pagination activée avec un contrôle client (le client peut envoyé le nombre de ligne par page souhaité)
                normalizationContext: ['groups' => ['collection.data.ps.read']], // Groupes de normalisation pour la sérialisation
                filters: ['list.rpps.search'], // Format de réponse
                name: 'listPS' // Filtres appliqués à cette opération (implementé dans services.yaml)
            ),
            new GetCollection( // Opération pour récupérer une collection de professionnels de santé
                uriTemplate: '/ps/listDoctors', // Nom de l'opération
                formats: 'json', // URL pour accéder à cette opération
                paginationItemsPerPage: 10, // Groupes de normalisation
                normalizationContext: ['groups' => ['collection.data.doctor.read']], // Limite de résultats par page
                filters: ['list.doctor.search'], // Format de réponse
                name: 'listDoctor' // Filtres appliqués à cette opération (implementé dans services.yaml)
            ),
            new GetCollection( // Opération pour récupérer une collection de départements
                uriTemplate: '/ps/listDepartments', // Nom de l'opération
                formats: 'json', // URL pour accéder à cette opération
                paginationEnabled: false, // Pagination désactivée
                filters: [], // Format de réponse
                name: 'listDepartments', // Fournisseur de données utilisé
                provider: DepartmentStateProvider::class // Aucun filtre appliqué
            ),
            new GetCollection(
                uriTemplate: 'address/list', // URI pour récupérer la liste des entities
                formats: ['json'],
                openapiContext: [
                    'parameters' => [
                        ['in' => 'query', 'name' => 'nbPage', 'schema' => ['type' => 'integer'], 'required' => false], // Paramètre pour le numéro de page
                        ['in' => 'query', 'name' => 'itemsPerPage', 'schema' => ['type' => 'integer'], 'required' => false], // Paramètre pour les éléments par page
                        ['in' => 'query', 'name' => 'orderBy', 'schema' => ['type' => 'string', 'enum' => ["name"]], 'required' => false],
                        ['in' => 'query', 'name' => 'direction', 'schema' => ['type' => 'string', 'enum' => ['DESC', 'ASC']], 'required' => false],
                        ['in' => 'query', 'name' => 'address', 'schema' => ['type' => 'string'], 'required' => true],
                    ],
                ],
                paginationEnabled: false, // Pagination désactivée
                deserialize: false, // Ne pas désérialiser le corps de la requête
                name: 'address-list',
                provider: AddressProvider::class, // Fournisseur pour gérer la logique
            ),
        ]
    )
]
#[ApiFilter(OrderFilter::class, properties: [
    'psFullname' => 'ASC',
], arguments: ['orderParameterName' => 'order'])]

class Rpps
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    #[Groups(['collection.data.ps.read', 'collection.data.doctor.read'])] // Groupe de sérialisation pour l'API listPS et listDoctor
    private ?int $id = null;

    #[ORM\Column(length: 255, nullable: true)]
    #[Groups(['collection.data.ps.read'])]
    private ?string $ppIdentifier = null;

    #[ORM\Column(length: 5, nullable: true)]
    private ?string $ppIdentifierType = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nameCode = null;

    #[ORM\Column(length: 20, nullable: true)]
    #[Groups(['collection.data.ps.read', 'collection.data.doctor.read'])] // Groupe de sérialisation pour l'API listPS et listDoctor
    private ?string $ppNationalIdentification = null;

    #[ORM\Column(length: 5, nullable: true)]
    #[Groups(['collection.data.ps.read'])]
    private ?string $exerciseCivilityCode = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $exerciseCivilityLabel = null;

    #[ORM\Column(length: 100, nullable: true)]
    #[Groups(['collection.data.ps.read'])]
    private ?string $exerciseName = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $exerciseNameBen = null;

    #[ORM\Column(length: 100, nullable: true)]
    #[Groups(['collection.data.ps.read'])]
    private ?string $firstnameExercise = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $firstnameExerciseCode = null;

    #[ORM\Column(length: 10, nullable: true)]
    private ?string $professionCode = null;

    #[ORM\Column(length: 255, nullable: true)]
    #[Groups(['collection.data.ps.read'])]
    private ?string $professionLabel = null;

    #[ORM\Column(length: 10, nullable: true)]
    private ?string $professionalCategoryCode = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $professionalCategoryLabel = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $knowHowCode = null;

    #[ORM\Column(length: 255, nullable: true)]
    #[Groups(['collection.data.ps.read'])]
    private ?string $knowHowLabel = null;

    #[ORM\Column(length: 10, nullable: true)]
    private ?string $knowHowCodeType = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $knowHowTypeLabel = null;

    #[ORM\Column(length: 20, nullable: true)]
    private ?string $numberSiretSite = null;

    #[ORM\Column(length: 20, nullable: true)]
    private ?string $numberSirenSite = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $numberFinessSite = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $numberFinessLegalEstablishment = null;

    #[ORM\Column(length: 200, nullable: true)]
    private ?string $socialReasonSite = null;

    #[ORM\Column(length: 200, nullable: true)]
    private ?string $commercialBrandSite = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $structureIdentifier = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $recipientComplementCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $complementPointGeographicCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $channelNumberCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $streetRepetitionIndexCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $streetCodeTypeCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $streetTypeLabelCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $streetLabelCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $distributionMentionCS = null;

    #[ORM\Column(length: 255, nullable: true)]
    #[Groups(['collection.data.ps.read'])]
    private ?string $officeCedexCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    #[Groups(['collection.data.ps.read'])]
    private ?string $postalCodeCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $municipalityCodeCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $municipalityLabelCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $countryCodeCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    #[Groups(['collection.data.ps.read'])]
    private ?string $countryLabelCs = null;

    #[ORM\Column(length: 100, nullable: true)]
    #[Groups(['collection.data.ps.read'])]
    private ?string $phoneNumberCs = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $phoneNumberCs2 = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $faxCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    #[Groups(['collection.data.ps.read'])]
    private ?string $mailCs = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $addressBalMssante = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $unknownColumn = null;

    #[ORM\Column(length: 300, nullable: true)]
    #[Groups(['collection.data.ps.read'])]
    private ?string $addr = null;

    #[ORM\Column]
    private ?int $idRpps = null;

    #[ORM\Column(length: 300)]
    private ?string $rs = null;

    #[ORM\Column(length: 300)]
    private ?string $ec = null;

    #[ORM\Column]
    private ?bool $isPharma = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $key1 = null;

    #[ORM\Column(nullable: true)]
    private ?int $flagkey1 = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $key2 = null;

    #[ORM\Column(nullable: true)]
    private ?int $flagkey2 = null;

    #[ORM\Column(nullable: true)]
    private ?int $flagkey3 = null;

    #[ORM\Column(length: 30, nullable: true)]
    private ?string $token = null;

    #[ORM\Column(nullable: true)]
    private ?int $flagtmp = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $name = null;

    #[ORM\Column(nullable: true)]
    private ?bool $isActive = null;

    #[ORM\Column(nullable: true)]
    private ?bool $isDelete = null;

    #[ORM\Column(length: 300, nullable: true)]
    #[Groups(['collection.data.ps.read', 'collection.data.doctor.read'])]
    private ?string $psFullname = null;

    #[ORM\Column(length: 2, nullable: true)]
    #[Groups(['collection.data.ps.read'])]
    private ?string $department = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPpIdentifier(): ?string
    {
        return $this->ppIdentifier;
    }

    public function setPpIdentifier(string $ppIdentifier): static
    {
        $this->ppIdentifier = $ppIdentifier;

        return $this;
    }

    public function getPpIdentifierType(): ?string
    {
        return $this->ppIdentifierType;
    }

    public function setPpIdentifierType(string $ppIdentifierType): static
    {
        $this->ppIdentifierType = $ppIdentifierType;

        return $this;
    }

    public function getNameCode(): ?string
    {
        return $this->nameCode;
    }

    public function setNameCode(string $nameCode): static
    {
        $this->nameCode = $nameCode;

        return $this;
    }

    public function getPpNationalIdentification(): ?string
    {
        return $this->ppNationalIdentification;
    }

    public function setPpNationalIdentification(string $ppNationalIdentification): static
    {
        $this->ppNationalIdentification = $ppNationalIdentification;

        return $this;
    }

    public function getExerciseCivilityCode(): ?string
    {
        return $this->exerciseCivilityCode;
    }

    public function setExerciseCivilityCode(string $exerciseCivilityCode): static
    {
        $this->exerciseCivilityCode = $exerciseCivilityCode;

        return $this;
    }

    public function getExerciseCivilityLabel(): ?string
    {
        return $this->exerciseCivilityLabel;
    }

    public function setExerciseCivilityLabel(string $exerciseCivilityLabel): static
    {
        $this->exerciseCivilityLabel = $exerciseCivilityLabel;

        return $this;
    }

    public function getExerciseName(): ?string
    {
        return $this->exerciseName;
    }

    public function setExerciseName(string $exerciseName): static
    {
        $this->exerciseName = $exerciseName;

        return $this;
    }

    public function getExerciseNameBen(): ?string
    {
        return $this->exerciseNameBen;
    }

    public function setExerciseNameBen(string $exerciseNameBen): static
    {
        $this->exerciseNameBen = $exerciseNameBen;

        return $this;
    }

    public function getFirstnameExercise(): ?string
    {
        return $this->firstnameExercise;
    }

    public function setFirstnameExercise(string $firstnameExercise): static
    {
        $this->firstnameExercise = $firstnameExercise;

        return $this;
    }

    public function getFirstnameExerciseCode(): ?string
    {
        return $this->firstnameExerciseCode;
    }

    public function setFirstnameExerciseCode(string $firstnameExerciseCode): static
    {
        $this->firstnameExerciseCode = $firstnameExerciseCode;

        return $this;
    }

    public function getProfessionCode(): ?string
    {
        return $this->professionCode;
    }

    public function setProfessionCode(string $professionCode): static
    {
        $this->professionCode = $professionCode;

        return $this;
    }

    public function getProfessionLabel(): ?string
    {
        return $this->professionLabel;
    }

    public function setProfessionLabel(string $professionLabel): static
    {
        $this->professionLabel = $professionLabel;

        return $this;
    }

    public function getProfessionalCategoryCode(): ?string
    {
        return $this->professionalCategoryCode;
    }

    public function setProfessionalCategoryCode(string $professionalCategoryCode): static
    {
        $this->professionalCategoryCode = $professionalCategoryCode;

        return $this;
    }

    public function getProfessionalCategoryLabel(): ?string
    {
        return $this->professionalCategoryLabel;
    }

    public function setProfessionalCategoryLabel(string $professionalCategoryLabel): static
    {
        $this->professionalCategoryLabel = $professionalCategoryLabel;

        return $this;
    }

    public function getKnowHowCode(): ?string
    {
        return $this->knowHowCode;
    }

    public function setKnowHowCode(string $knowHowCode): static
    {
        $this->knowHowCode = $knowHowCode;

        return $this;
    }

    public function getKnowHowLabel(): ?string
    {
        return $this->knowHowLabel;
    }

    public function setKnowHowLabel(string $knowHowLabel): static
    {
        $this->knowHowLabel = $knowHowLabel;

        return $this;
    }

    public function getKnowHowCodeType(): ?string
    {
        return $this->knowHowCodeType;
    }

    public function setKnowHowCodeType(string $knowHowCodeType): static
    {
        $this->knowHowCodeType = $knowHowCodeType;

        return $this;
    }

    public function getKnowHowTypeLabel(): ?string
    {
        return $this->knowHowTypeLabel;
    }

    public function setKnowHowTypeLabel(string $knowHowTypeLabel): static
    {
        $this->knowHowTypeLabel = $knowHowTypeLabel;

        return $this;
    }

    public function getNumberSiretSite(): ?string
    {
        return $this->numberSiretSite;
    }

    public function setNumberSiretSite(string $numberSiretSite): static
    {
        $this->numberSiretSite = $numberSiretSite;

        return $this;
    }

    public function getNumberSirenSite(): ?string
    {
        return $this->numberSirenSite;
    }

    public function setNumberSirenSite(string $numberSirenSite): static
    {
        $this->numberSirenSite = $numberSirenSite;

        return $this;
    }

    public function getNumberFinessSite(): ?string
    {
        return $this->numberFinessSite;
    }

    public function setNumberFinessSite(string $numberFinessSite): static
    {
        $this->numberFinessSite = $numberFinessSite;

        return $this;
    }

    public function getNumberFinessLegalEstablishment(): ?string
    {
        return $this->numberFinessLegalEstablishment;
    }

    public function setNumberFinessLegalEstablishment(string $numberFinessLegalEstablishment): static
    {
        $this->numberFinessLegalEstablishment = $numberFinessLegalEstablishment;

        return $this;
    }

    public function getSocialReasonSite(): ?string
    {
        return $this->socialReasonSite;
    }

    public function setSocialReasonSite(string $socialReasonSite): static
    {
        $this->socialReasonSite = $socialReasonSite;

        return $this;
    }

    public function getCommercialBrandSite(): ?string
    {
        return $this->commercialBrandSite;
    }

    public function setCommercialBrandSite(string $commercialBrandSite): static
    {
        $this->commercialBrandSite = $commercialBrandSite;

        return $this;
    }

    public function getStructureIdentifier(): ?string
    {
        return $this->structureIdentifier;
    }

    public function setStructureIdentifier(string $structureIdentifier): static
    {
        $this->structureIdentifier = $structureIdentifier;

        return $this;
    }

    public function getRecipientComplementCs(): ?string
    {
        return $this->recipientComplementCs;
    }

    public function setRecipientComplementCs(string $recipientComplementCs): static
    {
        $this->recipientComplementCs = $recipientComplementCs;

        return $this;
    }

    public function getComplementPointGeographicCs(): ?string
    {
        return $this->complementPointGeographicCs;
    }

    public function setComplementPointGeographicCs(string $complementPointGeographicCs): static
    {
        $this->complementPointGeographicCs = $complementPointGeographicCs;

        return $this;
    }

    public function getChannelNumberCs(): ?string
    {
        return $this->channelNumberCs;
    }

    public function setChannelNumberCs(string $channelNumberCs): static
    {
        $this->channelNumberCs = $channelNumberCs;

        return $this;
    }

    public function getStreetRepetitionIndexCs(): ?string
    {
        return $this->streetRepetitionIndexCs;
    }

    public function setStreetRepetitionIndexCs(string $streetRepetitionIndexCs): static
    {
        $this->streetRepetitionIndexCs = $streetRepetitionIndexCs;

        return $this;
    }

    public function getStreetCodeTypeCs(): ?string
    {
        return $this->streetCodeTypeCs;
    }

    public function setStreetCodeTypeCs(?string $streetCodeTypeCs): static
    {
        $this->streetCodeTypeCs = $streetCodeTypeCs;

        return $this;
    }

    public function getStreetTypeLabelCs(): ?string
    {
        return $this->streetTypeLabelCs;
    }

    public function setStreetTypeLabelCs(?string $streetTypeLabelCs): static
    {
        $this->streetTypeLabelCs = $streetTypeLabelCs;

        return $this;
    }

    public function getStreetLabelCs(): ?string
    {
        return $this->streetLabelCs;
    }

    public function setStreetLabelCs(?string $streetLabelCs): static
    {
        $this->streetLabelCs = $streetLabelCs;

        return $this;
    }

    public function getDistributionMentionCS(): ?string
    {
        return $this->distributionMentionCS;
    }

    public function setDistributionMentionCS(?string $distributionMentionCS): static
    {
        $this->distributionMentionCS = $distributionMentionCS;

        return $this;
    }

    public function getOfficeCedexCs(): ?string
    {
        return $this->officeCedexCs;
    }

    public function setOfficeCedexCs(?string $officeCedexCs): static
    {
        $this->officeCedexCs = $officeCedexCs;

        return $this;
    }

    public function getPostalCodeCs(): ?string
    {
        return $this->postalCodeCs;
    }

    public function setPostalCodeCs(?string $postalCodeCs): static
    {
        $this->postalCodeCs = $postalCodeCs;

        return $this;
    }

    public function getMunicipalityCodeCs(): ?string
    {
        return $this->municipalityCodeCs;
    }

    public function setMunicipalityCodeCs(?string $municipalityCodeCs): static
    {
        $this->municipalityCodeCs = $municipalityCodeCs;

        return $this;
    }

    public function getMunicipalityLabelCs(): ?string
    {
        return $this->municipalityLabelCs;
    }

    public function setMunicipalityLabelCs(?string $municipalityLabelCs): static
    {
        $this->municipalityLabelCs = $municipalityLabelCs;

        return $this;
    }

    public function getCountryCodeCs(): ?string
    {
        return $this->countryCodeCs;
    }

    public function setCountryCodeCs(?string $countryCodeCs): static
    {
        $this->countryCodeCs = $countryCodeCs;

        return $this;
    }

    public function getCountryLabelCs(): ?string
    {
        return $this->countryLabelCs;
    }

    public function setCountryLabelCs(?string $countryLabelCs): static
    {
        $this->countryLabelCs = $countryLabelCs;

        return $this;
    }

    public function getPhoneNumberCs(): ?string
    {
        return $this->phoneNumberCs;
    }

    public function setPhoneNumberCs(?string $phoneNumberCs): static
    {
        $this->phoneNumberCs = $phoneNumberCs;

        return $this;
    }

    public function getPhoneNumberCs2(): ?string
    {
        return $this->phoneNumberCs2;
    }

    public function setPhoneNumberCs2(?string $phoneNumberCs2): static
    {
        $this->phoneNumberCs2 = $phoneNumberCs2;

        return $this;
    }

    public function getFaxCs(): ?string
    {
        return $this->faxCs;
    }

    public function setFaxCs(?string $faxCs): static
    {
        $this->faxCs = $faxCs;

        return $this;
    }

    public function getMailCs(): ?string
    {
        return $this->mailCs;
    }

    public function setMailCs(?string $mailCs): static
    {
        $this->mailCs = $mailCs;

        return $this;
    }

    public function getAddressBalMssante(): ?string
    {
        return $this->addressBalMssante;
    }

    public function setAddressBalMssante(?string $addressBalMssante): static
    {
        $this->addressBalMssante = $addressBalMssante;

        return $this;
    }

    public function getUnknownColumn(): ?string
    {
        return $this->unknownColumn;
    }

    public function setUnknownColumn(?string $unknownColumn): static
    {
        $this->unknownColumn = $unknownColumn;

        return $this;
    }

    public function getAddr(): ?string
    {
        return $this->addr;
    }

    public function setAddr(?string $addr): static
    {
        $this->addr = $addr;

        return $this;
    }

    public function getIdRpps(): ?int
    {
        return $this->idRpps;
    }

    public function setIdRpps(int $idRpps): static
    {
        $this->idRpps = $idRpps;

        return $this;
    }

    public function getRs(): ?string
    {
        return $this->rs;
    }

    public function setRs(string $rs): static
    {
        $this->rs = $rs;

        return $this;
    }

    public function getEc(): ?string
    {
        return $this->ec;
    }

    public function setEc(string $ec): static
    {
        $this->ec = $ec;

        return $this;
    }

    public function isPharma(): ?bool
    {
        return $this->isPharma;
    }

    public function setPharma(bool $isPharma): static
    {
        $this->isPharma = $isPharma;

        return $this;
    }

    public function getKey1(): ?string
    {
        return $this->key1;
    }

    public function setKey1(?string $key1): static
    {
        $this->key1 = $key1;

        return $this;
    }

    public function getFlagkey1(): ?int
    {
        return $this->flagkey1;
    }

    public function setFlagkey1(?int $flagkey1): static
    {
        $this->flagkey1 = $flagkey1;

        return $this;
    }

    public function getKey2(): ?string
    {
        return $this->key2;
    }

    public function setKey2(?string $key2): static
    {
        $this->key2 = $key2;

        return $this;
    }

    public function getFlagkey2(): ?int
    {
        return $this->flagkey2;
    }

    public function setFlagkey2(?int $flagkey2): static
    {
        $this->flagkey2 = $flagkey2;

        return $this;
    }

    public function getFlagkey3(): ?int
    {
        return $this->flagkey3;
    }

    public function setFlagkey3(?int $flagkey3): static
    {
        $this->flagkey3 = $flagkey3;

        return $this;
    }

    public function getToken(): ?string
    {
        return $this->token;
    }

    public function setToken(?string $token): static
    {
        $this->token = $token;

        return $this;
    }

    public function getFlagtmp(): ?int
    {
        return $this->flagtmp;
    }

    public function setFlagtmp(?int $flagtmp): static
    {
        $this->flagtmp = $flagtmp;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function isActive(): ?bool
    {
        return $this->isActive;
    }

    public function setActive(?bool $isActive): static
    {
        $this->isActive = $isActive;

        return $this;
    }

    public function isDelete(): ?bool
    {
        return $this->isDelete;
    }

    public function setDelete(?bool $isDelete): static
    {
        $this->isDelete = $isDelete;

        return $this;
    }

    public function getPsFullname(): ?string
    {
        return $this->psFullname;
    }

    public function setPsFullname(?string $psFullname): static
    {
        $this->psFullname = $psFullname;

        return $this;
    }

    public function getDepartment(): ?string
    {
        return $this->department;
    }

    public function setDepartment(?string $department): static
    {
        $this->department = $department;

        return $this;
    }
}
