<?php

namespace App\Entity;

use ApiPlatform\Metadata\Get;
use Doctrine\ORM\Mapping\Index;
use Doctrine\ORM\Mapping as ORM;
use App\Repository\RppsPsRepository;
use ApiPlatform\Metadata\ApiResource;
use App\State\RppsProvider;

#[ORM\Entity(repositoryClass: RppsPsRepository::class)]

#[Index(name: "search_fullname", columns: ["ps_fullname"])]
#[Index(name: "search_sepeciality_code", columns: ["know_how_code"])]
#[Index(name: "search_department", columns: ["department"])]
#[Index(name: "search_fulltext", columns: ["ps_fullname", "know_how_code", "department"], flags: ["fulltext"])]
#[
    ApiResource(  // Déclaration de l'entité comme ressource API
        operations: [
            new Get( // Opération pour récupérer une collection de professionnels de santé
                uriTemplate: '/professional/list', // Nom de l'opération
                formats: 'json', // URL pour accéder à cette opération
                provider: RppsProvider::class,
                name: 'fetch-ps-list', // Nom de l'opération
                openapiContext: [
                    'parameters' => [
                        ['in' => 'query', 'name' => 'page', 'schema' => ['type' => 'integer'], 'required' => false],
                        ['in' => 'query', 'name' => 'itemsPerPage', 'schema' => ['type' => 'integer'], 'required' => false],
                        ['in' => 'query', 'name' => 'orderBy', 'schema' => ['type' => 'string', 'enum' => ["name"]], 'required' => false],
                        ['in' => 'query', 'name' => 'orderDirection', 'schema' => ['type' => 'string', 'enum' => ['ASC', 'DESC']], 'required' => false],
                        ['in' => 'query', 'name' => 'department', 'schema' => ['type' => 'string'], 'required' => false],
                        ['in' => 'query', 'name' => 'speciality', 'schema' => ['type' => 'array', 'items' => ['type' => 'string']], 'required' => false],
                        ['in' => 'query', 'name' => 'psFullname', 'schema' => ['type' => 'string'], 'required' => false],
                        ['in' => 'query', 'name' => 'ppNationalIdentification', 'schema' => ['type' => 'string'], 'required' => false],
                        ['in' => 'query', 'name' => 'phoneNumberCs', 'schema' => ['type' => 'string'], 'required' => false],
                        ['in' => 'query', 'name' => 'addr', 'schema' => ['type' => 'string'], 'required' => false],
                        ['in' => 'query', 'name' => 'firstnameExercise', 'schema' => ['type' => 'string'], 'required' => false],
                        ['in' => 'query', 'name' => 'exerciseName', 'schema' => ['type' => 'string'], 'required' => false],
                    ],
                ],
            ),
        ]
    )
]

class RppsPs
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 20, nullable: true)]
    private ?string $ppNationalIdentification = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $exerciseName = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $firstnameExercise = null;

    #[ORM\Column(length: 10, nullable: true)]
    private ?string $professionCode = null;

    #[ORM\Column(length: 10, nullable: true)]
    private ?string $professionalCategoryCode = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $knowHowCode = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $officeCedexCs = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $phoneNumberCs = null;

    #[ORM\Column(length: 300, nullable: true)]
    private ?string $addr = null;

    #[ORM\Column(length: 300, nullable: true)]
    private ?string $psFullname = null;

    #[ORM\Column(length: 2, nullable: true)]
    private ?string $department = null;

    public function getId(): ?int
    {
        return $this->id;
    }


    public function getPpNationalIdentification(): ?string
    {
        return $this->ppNationalIdentification;
    }

    public function setPpNationalIdentification(string $ppNationalIdentification): static
    {
        $this->ppNationalIdentification = $ppNationalIdentification;

        return $this;
    }

    public function getExerciseName(): ?string
    {
        return $this->exerciseName;
    }

    public function setExerciseName(string $exerciseName): static
    {
        $this->exerciseName = $exerciseName;

        return $this;
    }

    public function getFirstnameExercise(): ?string
    {
        return $this->firstnameExercise;
    }

    public function setFirstnameExercise(string $firstnameExercise): static
    {
        $this->firstnameExercise = $firstnameExercise;

        return $this;
    }

    public function getProfessionCode(): ?string
    {
        return $this->professionCode;
    }

    public function setProfessionCode(string $professionCode): static
    {
        $this->professionCode = $professionCode;

        return $this;
    }



    public function getProfessionalCategoryCode(): ?string
    {
        return $this->professionalCategoryCode;
    }

    public function setProfessionalCategoryCode(string $professionalCategoryCode): static
    {
        $this->professionalCategoryCode = $professionalCategoryCode;

        return $this;
    }


    public function getKnowHowCode(): ?string
    {
        return $this->knowHowCode;
    }

    public function setKnowHowCode(string $knowHowCode): static
    {
        $this->knowHowCode = $knowHowCode;

        return $this;
    }

    public function getOfficeCedexCs(): ?string
    {
        return $this->officeCedexCs;
    }

    public function setOfficeCedexCs(?string $officeCedexCs): static
    {
        $this->officeCedexCs = $officeCedexCs;

        return $this;
    }



    public function getPhoneNumberCs(): ?string
    {
        return $this->phoneNumberCs;
    }

    public function setPhoneNumberCs(?string $phoneNumberCs): static
    {
        $this->phoneNumberCs = $phoneNumberCs;

        return $this;
    }

    public function getAddr(): ?string
    {
        return $this->addr;
    }

    public function setAddr(?string $addr): static
    {
        $this->addr = $addr;

        return $this;
    }

    public function getPsFullname(): ?string
    {
        return $this->psFullname;
    }

    public function setPsFullname(?string $psFullname): static
    {
        $this->psFullname = $psFullname;

        return $this;
    }

    public function getDepartment(): ?string
    {
        return $this->department;
    }

    public function setDepartment(?string $department): static
    {
        $this->department = $department;

        return $this;
    }
}
