<?php

namespace App\Entity;

use ApiPlatform\Doctrine\Orm\Filter\OrderFilter;
use ApiPlatform\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Metadata\ApiFilter;
use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use App\Repository\SpecialityRepository;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Attribute\Groups;

#[
    ApiResource(
        operations: [
            new GetCollection(
                uriTemplate: '/ps/listSpecialities',
                formats: ['json'],
                paginationEnabled: false,
                name: 'listSpecialities' // Filtres appliqués à cette opération (implementé dans services.yaml)

            )
        ])
]
#[ApiFilter(SearchFilter::class, properties: ['designation' => 'exact'])] // Un filtre permet de rechercher une spécialité par sa désignation.
#[ApiFilter(OrderFilter::class, properties: [
    'designation' => 'ASC',
], arguments: ['orderParameterName' => 'order'])]

#[ORM\Entity(repositoryClass: SpecialityRepository::class)]
class Speciality
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 10)]
    #[Groups(['collection.data.specialities.read'])]
    private ?string $code = null;

    #[ORM\Column(length: 255)]
    #[Groups(['collection.data.specialities.read'])]
    private ?string $designation = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): static
    {
        $this->code = $code;

        return $this;
    }

    public function getDesignation(): ?string
    {
        return $this->designation;
    }

    public function setDesignation(string $designation): static
    {
        $this->designation = $designation;

        return $this;
    }
}
