<?php

namespace App\Repository;

use App\Entity\Rpps;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Rpps>
 */
class RppsRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Rpps::class);
    }

    public function listDepartments()
    {
        return $this->createQueryBuilder('r') // Création d'un query builder pour l'entité Rpps.
            ->select('DISTINCT(r.department)') // Sélectionne uniquement les départements distincts.
            ->where('r.department != :emptyDepartment') // Exclut les départements vides.
            ->setParameter(':emptyDepartment', "") // Paramètre de comparaison pour les départements vides.
            ->getQuery() // Génère la requête.
            ->getSingleColumnResult(); // Exécute la requête et retourne les résultats sous forme d'un tableau.
    }
}
