<?php

namespace App\Service;

use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Contracts\HttpClient\HttpClientInterface;

class ApiAddressService
{

    // Déclare la variable pour l'interface HttpClient, qui permettra de faire des requêtes HTTP.
    private $client;

    // Le constructeur injecte l'interface HttpClient pour faire des appels API.
    public function __construct(HttpClientInterface $client)
    {
        $this->client = $client;
    }

    // Cette méthode récupère les communes correspondant à un code postal donné à partir d'une API gouvernementale.
    public function fetchMunicipalities($postalCode = null)
    {
        // Envoie une requête GET à l'API des communes en utilisant le code postal fourni dans les paramètres.
        $response = $this->client->request('GET', 'https://geo.api.gouv.fr/communes', [
            'query' => [
                'codePostal' => $postalCode,
            ],
        ]);

        // Retourne les résultats de la requête sous forme de tableau.
        return $response->toArray();
    }

    // Cette méthode récupère des adresses basées sur une recherche textuelle, un code postal et un code de ville.
    public function fetchAddresses(
        ?string $q = null,
        ?string $postalCode = null,
        ?string $cityCode = null,
        int     $limit = 100
    ): array
    {

        $result = array();
        // Construction des paramètres de la requête
        $queryParams = [
            'q' => $q, // Chaîne de caractères à rechercher
            'postcode' => $postalCode, // Filtre par code postal
            'citycode' => $cityCode, // Filtre par code de ville
            'limit' => $limit, // Limite des résultats
            'autocomplete' => 1 // Activer l'autocomplétion
        ];

        // Génération de l'URL avec http_build_query
        $url = 'https://api-adresse.data.gouv.fr/search?' . http_build_query($queryParams);

        // Envoi de la requête GET à l'URL générée
        $response = $this->client->request('GET', $url);

        // Vérification du code HTTP de la réponse
        if ($response->getStatusCode() == 200) {
            // Retourne uniquement les adresses sous la clé "features" dans le tableau de résultats
            $result = $response->toArray()['features'];
        }

        return $result;
    }


}