<?php

namespace App\Service;

use Symfony\Contracts\HttpClient\HttpClientInterface;

class ApiSirenService
{

    // Cette méthode récupère les informations d'une société à partir de son SIREN via une API gouvernementale.
    public function fetchSociety(HttpClientInterface $client, $siren = null)
    {

        // Envoie une requête GET à l'API des entreprises avec le SIREN comme paramètre de recherche.
        $response = $client->request('GET', 'https://recherche-entreprises.api.gouv.fr/search', [
            'query' => [
                'q' => $siren, // Le SIREN utilisé pour la recherche.
            ],
        ]);

        $company = null; // Variable pour stocker les informations de l'entreprise récupérée.
        $data = $response->toArray()["results"]; // Récupère les résultats de la requête sous forme de tableau.

        // Si des données sont trouvées, on boucle pour vérifier si le SIREN correspond à celui recherché.
        if (count($data) > 0) {
            foreach ($data as $row) {
                if ($row['siren'] == $siren) {
                    $company = $row;  // Si le SIREN correspond, les informations de la société sont stockées dans $company.

                }
            }
        }

        return $company; // Retourne les informations de l'entreprise ou null si non trouvée.
    }


    // Cette méthode génère un numéro de TVA à partir du SIREN fourni, selon la formule française.
    public function getNumTva($siren)
    {
        /** La clé française suit la règle suivante :
         *Clé TVA = [12 + 3 × (SIREN modulo 97)] modulo 97
         **/
        $key_tva = fmod(12 + 3 * (fmod($siren, 97)), 97);

        /* num tva: FRCléSiren*/
        return "FR" . $key_tva . $siren;
    }

}