<?php

namespace ContainerFPYksdx;

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/**
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class App_KernelDevDebugContainer extends Container
{
    protected $targetDir;
    protected $parameters = [];
    protected \Closure $getService;

    public function __construct(private array $buildParameters = [], protected string $containerDir = __DIR__)
    {
        $this->targetDir = \dirname($containerDir);
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'kernel' => true,
        ];
        $this->methodMap = [
            'api_platform.state_provider.parameter_validator' => 'getApiPlatform_StateProvider_ParameterValidatorService',
            'cache.security_is_granted_attribute_expression_language' => 'getCache_SecurityIsGrantedAttributeExpressionLanguageService',
            'debug.stopwatch' => 'getDebug_StopwatchService',
            'doctrine' => 'getDoctrineService',
            'doctrine.dbal.default_connection' => 'getDoctrine_Dbal_DefaultConnectionService',
            'doctrine.orm.default_entity_manager' => 'getDoctrine_Orm_DefaultEntityManagerService',
            'event_dispatcher' => 'getEventDispatcherService',
            'http_kernel' => 'getHttpKernelService',
            'request_stack' => 'getRequestStackService',
            'router' => 'getRouterService',
        ];
        $this->fileMap = [
            'App\\Controller\\HomeController' => 'getHomeControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\RedirectController' => 'getRedirectControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController' => 'getTemplateControllerService',
            'api_platform.action.documentation' => 'getApiPlatform_Action_DocumentationService',
            'api_platform.action.entrypoint' => 'getApiPlatform_Action_EntrypointService',
            'api_platform.action.error_page' => 'getApiPlatform_Action_ErrorPageService',
            'api_platform.action.exception' => 'getApiPlatform_Action_ExceptionService',
            'api_platform.action.not_exposed' => 'getApiPlatform_Action_NotExposedService',
            'api_platform.action.not_found' => 'getApiPlatform_Action_NotFoundService',
            'api_platform.action.placeholder' => 'getApiPlatform_Action_PlaceholderService',
            'api_platform.jsonld.action.context' => 'getApiPlatform_Jsonld_Action_ContextService',
            'api_platform.swagger_ui.action' => 'getApiPlatform_SwaggerUi_ActionService',
            'cache.app' => 'getCache_AppService',
            'cache.app_clearer' => 'getCache_AppClearerService',
            'cache.global_clearer' => 'getCache_GlobalClearerService',
            'cache.system' => 'getCache_SystemService',
            'cache.system_clearer' => 'getCache_SystemClearerService',
            'cache.validator_expression_language' => 'getCache_ValidatorExpressionLanguageService',
            'cache_warmer' => 'getCacheWarmerService',
            'console.command_loader' => 'getConsole_CommandLoaderService',
            'container.env_var_processors_locator' => 'getContainer_EnvVarProcessorsLocatorService',
            'container.get_routing_condition_service' => 'getContainer_GetRoutingConditionServiceService',
            'debug.error_handler_configurator' => 'getDebug_ErrorHandlerConfiguratorService',
            'error_controller' => 'getErrorControllerService',
            'routing.loader' => 'getRouting_LoaderService',
            'services_resetter' => 'getServicesResetterService',
        ];
        $this->aliases = [
            'ApiPlatform\\Action\\NotExposedAction' => 'api_platform.action.not_exposed',
            'ApiPlatform\\Action\\NotFoundAction' => 'api_platform.action.not_found',
            'ApiPlatform\\Action\\PlaceholderAction' => 'api_platform.action.placeholder',
            'ApiPlatform\\Symfony\\Action\\NotExposedAction' => 'api_platform.action.not_exposed',
            'ApiPlatform\\Symfony\\Action\\NotFoundAction' => 'api_platform.action.not_found',
            'ApiPlatform\\Symfony\\Action\\PlaceholderAction' => 'api_platform.action.placeholder',
            'App\\Kernel' => 'kernel',
            'api_platform.action.delete_item' => 'api_platform.action.placeholder',
            'api_platform.action.get_collection' => 'api_platform.action.placeholder',
            'api_platform.action.get_item' => 'api_platform.action.placeholder',
            'api_platform.action.patch_item' => 'api_platform.action.placeholder',
            'api_platform.action.post_collection' => 'api_platform.action.placeholder',
            'api_platform.action.put_item' => 'api_platform.action.placeholder',
            'database_connection' => 'doctrine.dbal.default_connection',
            'doctrine.orm.entity_manager' => 'doctrine.orm.default_entity_manager',
        ];

        $this->privates['service_container'] = static function ($container) {
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventSubscriberInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ResponseListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/LocaleListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/DisallowRobotsIndexingListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ErrorListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/CacheAttributeListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/container/src/ContainerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/RunnerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/Runner/Symfony/HttpKernelRunner.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/Runner/Symfony/ResponseRunner.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/RuntimeInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/GenericRuntime.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/SymfonyRuntime.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpKernelInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/TerminableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpKernel.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ControllerResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/TraceableControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/TraceableArgumentResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ArgumentResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceLocatorTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ServiceLocator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/RequestStack.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ResetInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/stopwatch/Stopwatch.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RequestContext.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/expression-language/ExpressionFunctionProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/ExpressionLanguageProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/RouterListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-access/PropertyAccessorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-access/PropertyAccessor.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/cache/src/CacheItemPoolInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/AdapterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache-contracts/CacheInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/src/LoggerAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/ResettableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/src/LoggerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/ArrayAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/SerializerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/NormalizerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ContextAwareNormalizerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DenormalizerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ContextAwareDenormalizerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/EncoderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/ContextAwareEncoderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/DecoderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/ContextAwareDecoderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Serializer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/SerializerAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/CacheableSupportsMethodInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/SerializerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/UnwrappingDenormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/OpenApi/Serializer/LegacyOpenApiNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/OpenApi/Serializer/CacheableSupportsMethodInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/OpenApi/Serializer/ApiGatewayNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/OpenApi/Serializer/OpenApiNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ObjectToPopulateTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/AbstractNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/AbstractObjectNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ObjectNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/JsonEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/CacheableSupportsMethodInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/AbstractConstraintViolationListNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/ConstraintViolationListNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonLd/Serializer/HydraPrefixTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Hydra/Serializer/ConstraintViolationListNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Problem/Serializer/ConstraintViolationListNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/Validator/Serializer/ValidationExceptionNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonLd/Serializer/ErrorNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Util/ClassInfoTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Util/CloneTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/ContextTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/InputOutputMetadataTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/OperationContextTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/AbstractItemNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonLd/Serializer/JsonLdContextTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonLd/Serializer/ItemNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Hydra/Serializer/DocumentationNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Hydra/Serializer/EntrypointNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Hydra/Serializer/ErrorNormalizerTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Hydra/Serializer/ErrorNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/ItemNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Problem/Serializer/ErrorNormalizerTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Problem/Serializer/ErrorNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ProblemNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/UidNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DateTimeNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ConstraintViolationListNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DateTimeZoneNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DateIntervalNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/FormErrorNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/BackedEnumNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DataUriNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/JsonSerializableNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/NormalizerAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Hydra/Serializer/CollectionFiltersNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Hydra/Serializer/PartialCollectionViewNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/NormalizerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/AbstractCollectionNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Hydra/Serializer/CollectionNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DenormalizerAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DenormalizerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ArrayDenormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonLd/Serializer/ObjectNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/ClassDiscriminatorResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/ClassDiscriminatorFromClassMetadata.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/NormalizationAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/XmlEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/YamlEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/CsvEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/JsonEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/YamlEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/NameConverter/NameConverterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/NameConverter/AdvancedNameConverterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/NameConverter/MetadataAwareNameConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyTypeExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyDescriptionExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyAccessExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyListExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyInfoExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyInitializableExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyInfoExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyReadInfoExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyWriteInfoExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/Extractor/ConstructorArgumentTypeExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/Extractor/ReflectionExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/web-link/HttpHeaderSerializer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/web-link/EventListener/AddLinkHeaderListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/AbstractSessionListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/SessionListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Factory/MetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Validator/ValidatorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ValidatorBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Validation.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ConstraintValidatorFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ContainerConstraintValidatorFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ObjectInitializerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/Validator/DoctrineInitializer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Loader/AutoMappingTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Loader/PropertyInfoLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/Validator/DoctrineLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AuthorizationCheckerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AuthorizationChecker.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/Token/Storage/TokenStorageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceSubscriberInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/Token/Storage/UsageTrackingTokenStorage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/Token/Storage/TokenStorage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/AuthenticationTrustResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/AuthenticationTrustResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/expression-language/ExpressionLanguage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/ExpressionLanguage.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/Security/Core/Authorization/ExpressionLanguageProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Role/RoleHierarchyInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Role/RoleHierarchy.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/FirewallMapInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-bundle/Security/FirewallMap.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Logout/LogoutUrlGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/AbstractAdapterTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache-contracts/CacheTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/ContractsTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/AbstractAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/EventListener/IsGrantedAttributeListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AccessDecisionManagerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/TraceableAccessDecisionManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AccessDecisionManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/Strategy/AccessDecisionStrategyInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/Strategy/AffirmativeStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Firewall.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-bundle/EventListener/FirewallListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-bundle/Debug/TraceableFirewallListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/ConnectionRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/ManagerRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/AbstractManagerRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/ManagerRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Registry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/event-manager/src/EventManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/ContainerAwareEventManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Connection.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/ConnectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Configuration.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Schema/SchemaManagerFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Schema/LegacySchemaManagerFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Dbal/SchemaAssetsFilterManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Driver/Middleware.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Middleware/ConnectionNameAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Middleware/DebugMiddleware.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Tools/DsnParser.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/Middleware/Debug/DebugDataHolder.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Middleware/BacktraceDebugDataHolder.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Configuration.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/Mapping/Driver/MappingDriver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Mapping/MappingDriver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/Mapping/Driver/MappingDriverChain.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/NamingStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/UnderscoreNamingStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/QuoteStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Internal/SQLResultCasing.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/DefaultQuoteStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/TypedFieldMapper.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/DefaultTypedFieldMapper.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/EntityListenerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Mapping/EntityListenerServiceResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Mapping/ContainerEntityListenerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Repository/RepositoryFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Repository/RepositoryFactoryCompatibility.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Repository/ContainerRepositoryFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/Mapping/Driver/ColocatedMappingDriver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/Driver/ReflectionBasedDriver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/Driver/AttributeDriver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/ManagerConfigurator.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-migrations-bundle/src/EventListener/SchemaFilterListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/EventListener/CorsListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/Options/ResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/Options/Resolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/Options/ProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/Options/ConfigProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/EventListener/CacheableResponseVaryListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/State/ProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/State/CallableProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/willdurand/negotiation/src/Negotiation/AbstractNegotiator.php';
            include_once \dirname(__DIR__, 4).'/vendor/willdurand/negotiation/src/Negotiation/Negotiator.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Api/ResourceClassResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/ResourceClassResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RequestContextAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/UrlMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Generator/UrlGeneratorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RouterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Api/UrlGeneratorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/Routing/Router.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/Mapping/Factory/ClassMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Factory/ClassResolverTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Loader/LoaderChain.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Loader/AttributeLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Api/IriConverterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/Routing/SkolemIriConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Api/IdentifiersExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Util/ResourceClassInfoTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/IdentifiersExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Api/UriVariablesConverterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/UriVariablesConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/State/UriVariablesResolverTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/Routing/IriConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/State/Util/OperationRequestInitiatorTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/EventListener/AddFormatListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Util/ContentNegotiationTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/State/Provider/ContentNegotiationProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/EventListener/ReadListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/State/Util/ParameterParserTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/State/Provider/SecurityParameterProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/Security/State/AccessCheckerProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/Bundle/SwaggerUi/SwaggerUiProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/State/Provider/ParameterProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/EventListener/DeserializeListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/State/Provider/DeserializeProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ResourceNameCollectionFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Util/CachedTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/CachedResourceNameCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ExtractorResourceNameCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ClassNameResourceNameCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/AttributesResourceNameCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ConcernsResourceNameCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Property/Factory/PropertyNameCollectionFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Property/Factory/CachedPropertyNameCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Property/Factory/ExtractorPropertyNameCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Property/Factory/ConcernsPropertyNameCollectionMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Property/Factory/PropertyInfoPropertyNameCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Extractor/ResourceExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Extractor/AbstractResourceExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Extractor/ResourceExtractorTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Extractor/XmlResourceExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Extractor/PropertyExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Extractor/AbstractPropertyExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Extractor/XmlPropertyExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Property/Factory/PropertyMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Property/Factory/CachedPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonSchema/Metadata/Property/Factory/SchemaPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/Validator/Metadata/Property/ValidatorPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Property/Factory/ExtractorPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Property/Factory/AttributePropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Property/Factory/IdentifierPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Property/Factory/DefaultPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Property/Factory/SerializerPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Doctrine/Orm/Metadata/Property/DoctrineOrmPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Property/Factory/PropertyInfoPropertyMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ResourceMetadataCollectionFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/CachedResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Doctrine/Orm/Metadata/Resource/DoctrineOrmResourceCollectionMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/PhpDocResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/AlternateUriResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Util/AttributeFilterExtractorTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/FiltersResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/FormatsResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/InputOutputResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/OperationDefaultsTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/OperationNameResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/LinkResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/LinkFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/PropertyLinkFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Doctrine/Orm/Metadata/Resource/DoctrineOrmLinkFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/LinkFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/MainControllerResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/UriTemplateResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Operation/PathSegmentNameGeneratorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Operation/UnderscorePathSegmentNameGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/InflectorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Util/Inflector.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/BackedEnumResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/NotExposedOperationResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ExtractorResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/MetadataCollectionFactoryTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ConcernsResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/ParameterResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/DeprecationResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Resource/Factory/AttributesResourceMetadataCollectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Operation/Factory/OperationMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Operation/Factory/OperationMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Extractor/YamlResourceExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/Extractor/YamlPropertyExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonSchema/SchemaFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonSchema/SchemaFactoryAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonSchema/BackwardCompatibleSchemaFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Hydra/JsonSchema/SchemaFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonSchema/ResourceMetadataTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonSchema/SchemaFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonSchema/TypeFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonSchema/TypeFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonSchema/DefinitionNameFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonSchema/DefinitionNameFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/State/SerializerContextBuilderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/SerializerContextBuilderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/OpenApi/Serializer/SerializerContextBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/SerializerFilterContextBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Serializer/SerializerContextBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/OpenApi/Options.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/OpenApi/Factory/OpenApiFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/OpenApi/Serializer/NormalizeOperationNameTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/OpenApi/Factory/TypeFactoryTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/OpenApi/Factory/OpenApiFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/State/Pagination/PaginationOptions.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonLd/ContextBuilderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonLd/AnonymousContextBuilderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/JsonLd/ContextBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Hydra/Serializer/HydraPrefixNameConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/Validator/State/ParameterValidatorProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/State/Provider/ReadProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/EventListener/QueryParameterValidateListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Metadata/ResourceAccessCheckerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/Security/ResourceAccessCheckerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/Security/ResourceAccessChecker.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/src/LoggerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/src/LoggerTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/src/AbstractLogger.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Log/DebugLoggerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Log/Logger.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/RequestMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Router.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Routing/Router.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/config/ConfigCacheFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/config/ResourceCheckerConfigCacheFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/event-dispatcher/src/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/Debug/TraceableEventDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Debug/TraceableEventDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventDispatcher.php';
        };
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return require $this->containerDir.\DIRECTORY_SEPARATOR.'removed-ids.php';
    }

    protected function load($file, $lazyLoad = true): mixed
    {
        if (class_exists($class = __NAMESPACE__.'\\'.$file, false)) {
            return $class::do($this, $lazyLoad);
        }

        if ('.' === $file[-4]) {
            $class = substr($class, 0, -4);
        } else {
            $file .= '.php';
        }

        $service = require $this->containerDir.\DIRECTORY_SEPARATOR.$file;

        return class_exists($class, false) ? $class::do($this, $lazyLoad) : $service;
    }

    protected function createProxy($class, \Closure $factory)
    {
        class_exists($class, false) || require __DIR__.'/'.$class.'.php';

        return $factory();
    }

    /**
     * Gets the public 'api_platform.state_provider.parameter_validator' shared service.
     *
     * @return \ApiPlatform\Symfony\Validator\State\ParameterValidatorProvider
     */
    protected static function getApiPlatform_StateProvider_ParameterValidatorService($container)
    {
        return $container->services['api_platform.state_provider.parameter_validator'] = new \ApiPlatform\Symfony\Validator\State\ParameterValidatorProvider(($container->privates['validator'] ?? self::getValidatorService($container)), new \ApiPlatform\State\Provider\ReadProvider(($container->privates['api_platform.state_provider.locator'] ?? self::getApiPlatform_StateProvider_LocatorService($container)), ($container->privates['api_platform.openapi.serializer_context_builder'] ?? self::getApiPlatform_Openapi_SerializerContextBuilderService($container)), ($container->privates['logger'] ?? self::getLoggerService($container))));
    }

    /**
     * Gets the public 'cache.security_is_granted_attribute_expression_language' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_SecurityIsGrantedAttributeExpressionLanguageService($container)
    {
        return $container->services['cache.security_is_granted_attribute_expression_language'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('1oPHRKczQZ', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['logger'] ?? self::getLoggerService($container)));
    }

    /**
     * Gets the public 'debug.stopwatch' shared service.
     *
     * @return \Symfony\Component\Stopwatch\Stopwatch
     */
    protected static function getDebug_StopwatchService($container)
    {
        return $container->services['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true);
    }

    /**
     * Gets the public 'doctrine' shared service.
     *
     * @return \Doctrine\Bundle\DoctrineBundle\Registry
     */
    protected static function getDoctrineService($container)
    {
        return $container->services['doctrine'] = new \Doctrine\Bundle\DoctrineBundle\Registry($container, $container->parameters['doctrine.connections'], $container->parameters['doctrine.entity_managers'], 'default', 'default');
    }

    /**
     * Gets the public 'doctrine.dbal.default_connection' shared service.
     *
     * @return \Doctrine\DBAL\Connection
     */
    protected static function getDoctrine_Dbal_DefaultConnectionService($container)
    {
        $a = new \Doctrine\DBAL\Configuration();

        $b = new \Doctrine\Bundle\DoctrineBundle\Middleware\DebugMiddleware(($container->privates['doctrine.debug_data_holder'] ??= new \Doctrine\Bundle\DoctrineBundle\Middleware\BacktraceDebugDataHolder(['default'])), ($container->services['debug.stopwatch'] ??= new \Symfony\Component\Stopwatch\Stopwatch(true)));
        $b->setConnectionName('default');

        $a->setSchemaManagerFactory(new \Doctrine\DBAL\Schema\LegacySchemaManagerFactory());
        $a->setSchemaAssetsFilter(new \Doctrine\Bundle\DoctrineBundle\Dbal\SchemaAssetsFilterManager([($container->privates['doctrine_migrations.schema_filter_listener'] ??= new \Doctrine\Bundle\MigrationsBundle\EventListener\SchemaFilterListener('doctrine_migration_versions'))]));
        $a->setMiddlewares([$b]);

        $container->services['doctrine.dbal.default_connection'] = $instance = (new \Doctrine\Bundle\DoctrineBundle\ConnectionFactory([], new \Doctrine\DBAL\Tools\DsnParser(['db2' => 'ibm_db2', 'mssql' => 'pdo_sqlsrv', 'mysql' => 'pdo_mysql', 'mysql2' => 'pdo_mysql', 'postgres' => 'pdo_pgsql', 'postgresql' => 'pdo_pgsql', 'pgsql' => 'pdo_pgsql', 'sqlite' => 'pdo_sqlite', 'sqlite3' => 'pdo_sqlite'])))->createConnection(['url' => $container->getEnv('resolve:DATABASE_URL'), 'use_savepoints' => true, 'driver' => 'pdo_mysql', 'idle_connection_ttl' => 600, 'host' => 'localhost', 'port' => NULL, 'user' => 'root', 'password' => NULL, 'driverOptions' => [], 'defaultTableOptions' => []], $a, ($container->privates['doctrine.dbal.default_connection.event_manager'] ?? self::getDoctrine_Dbal_DefaultConnection_EventManagerService($container)), []);

        $instance->setNestTransactionsWithSavepoints(true);

        return $instance;
    }

    /**
     * Gets the public 'doctrine.orm.default_entity_manager' shared service.
     *
     * @return \Doctrine\ORM\EntityManager
     */
    protected static function getDoctrine_Orm_DefaultEntityManagerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['doctrine.orm.default_entity_manager'] = $container->createProxy('EntityManagerGhostEbeb667', static fn () => \EntityManagerGhostEbeb667::createLazyGhost(static fn ($proxy) => self::getDoctrine_Orm_DefaultEntityManagerService($container, $proxy)));
        }

        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Proxy/Autoloader.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/ObjectManager.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/EntityManagerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/EntityManager.php';

        $instance = ($lazyLoad->__construct(($container->services['doctrine.dbal.default_connection'] ?? self::getDoctrine_Dbal_DefaultConnectionService($container)), ($container->privates['doctrine.orm.default_configuration'] ?? self::getDoctrine_Orm_DefaultConfigurationService($container)), ($container->privates['doctrine.dbal.default_connection.event_manager'] ?? self::getDoctrine_Dbal_DefaultConnection_EventManagerService($container))) && false ?: $lazyLoad);

        ($container->privates['doctrine.orm.default_manager_configurator'] ??= new \Doctrine\Bundle\DoctrineBundle\ManagerConfigurator([], []))->configure($instance);

        return $instance;
    }

    /**
     * Gets the public 'event_dispatcher' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Debug\TraceableEventDispatcher
     */
    protected static function getEventDispatcherService($container)
    {
        $container->services['event_dispatcher'] = $instance = new \Symfony\Component\HttpKernel\Debug\TraceableEventDispatcher(new \Symfony\Component\EventDispatcher\EventDispatcher(), ($container->services['debug.stopwatch'] ??= new \Symfony\Component\Stopwatch\Stopwatch(true)), ($container->privates['logger'] ?? self::getLoggerService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));

        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.user_provider', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserProviderListener')] fn () => ($container->privates['security.listener.user_provider'] ?? $container->load('getSecurity_Listener_UserProviderService')), 'checkPassport'], 1024);
        $instance->addListener('console.command', [#[\Closure(name: 'doctrine_migrations.schema_filter_listener', class: 'Doctrine\\Bundle\\MigrationsBundle\\EventListener\\SchemaFilterListener')] fn () => ($container->privates['doctrine_migrations.schema_filter_listener'] ??= new \Doctrine\Bundle\MigrationsBundle\EventListener\SchemaFilterListener('doctrine_migration_versions')), 'onConsoleCommand'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'nelmio_cors.cors_listener', class: 'Nelmio\\CorsBundle\\EventListener\\CorsListener')] fn () => ($container->privates['nelmio_cors.cors_listener'] ?? self::getNelmioCors_CorsListenerService($container)), 'onKernelRequest'], 250);
        $instance->addListener('kernel.response', [#[\Closure(name: 'nelmio_cors.cors_listener', class: 'Nelmio\\CorsBundle\\EventListener\\CorsListener')] fn () => ($container->privates['nelmio_cors.cors_listener'] ?? self::getNelmioCors_CorsListenerService($container)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'nelmio_cors.cacheable_response_vary_listener', class: 'Nelmio\\CorsBundle\\EventListener\\CacheableResponseVaryListener')] fn () => ($container->privates['nelmio_cors.cacheable_response_vary_listener'] ??= new \Nelmio\CorsBundle\EventListener\CacheableResponseVaryListener()), 'onResponse'], -10);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'api_platform.listener.exception', class: 'ApiPlatform\\Symfony\\EventListener\\ExceptionListener')] fn () => ($container->privates['api_platform.listener.exception'] ?? $container->load('getApiPlatform_Listener_ExceptionService')), 'onKernelException'], -96);
        $instance->addListener('kernel.request', [#[\Closure(name: 'api_platform.listener.request.add_format', class: 'ApiPlatform\\Symfony\\EventListener\\AddFormatListener')] fn () => ($container->privates['api_platform.listener.request.add_format'] ?? self::getApiPlatform_Listener_Request_AddFormatService($container)), 'onKernelRequest'], 28);
        $instance->addListener('kernel.request', [#[\Closure(name: 'api_platform.listener.request.read', class: 'ApiPlatform\\Symfony\\EventListener\\ReadListener')] fn () => ($container->privates['api_platform.listener.request.read'] ?? self::getApiPlatform_Listener_Request_ReadService($container)), 'onKernelRequest'], 4);
        $instance->addListener('kernel.request', [#[\Closure(name: 'api_platform.listener.request.deserialize', class: 'ApiPlatform\\Symfony\\EventListener\\DeserializeListener')] fn () => ($container->privates['api_platform.listener.request.deserialize'] ?? self::getApiPlatform_Listener_Request_DeserializeService($container)), 'onKernelRequest'], 2);
        $instance->addListener('kernel.view', [#[\Closure(name: 'api_platform.listener.view.write', class: 'ApiPlatform\\Symfony\\EventListener\\WriteListener')] fn () => ($container->privates['api_platform.listener.view.write'] ?? $container->load('getApiPlatform_Listener_View_WriteService')), 'onKernelView'], 32);
        $instance->addListener('kernel.view', [#[\Closure(name: 'api_platform.listener.view.serialize', class: 'ApiPlatform\\Symfony\\EventListener\\SerializeListener')] fn () => ($container->privates['api_platform.listener.view.serialize'] ?? $container->load('getApiPlatform_Listener_View_SerializeService')), 'onKernelView'], 16);
        $instance->addListener('kernel.view', [#[\Closure(name: 'api_platform.listener.view.respond', class: 'ApiPlatform\\Symfony\\EventListener\\RespondListener')] fn () => ($container->privates['api_platform.listener.view.respond'] ?? $container->load('getApiPlatform_Listener_View_RespondService')), 'onKernelView'], 8);
        $instance->addListener('kernel.view', [#[\Closure(name: 'api_platform.listener.view.validate', class: 'ApiPlatform\\Symfony\\EventListener\\ValidateListener')] fn () => ($container->privates['api_platform.listener.view.validate'] ?? $container->load('getApiPlatform_Listener_View_ValidateService')), 'onKernelView'], 64);
        $instance->addListener('kernel.request', [#[\Closure(name: 'api_platform.listener.view.validate_query_parameters', class: 'ApiPlatform\\Symfony\\EventListener\\QueryParameterValidateListener')] fn () => ($container->privates['api_platform.listener.view.validate_query_parameters'] ?? self::getApiPlatform_Listener_View_ValidateQueryParametersService($container)), 'onKernelRequest'], 16);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'argument_resolver.request_payload', class: 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver')] fn () => ($container->privates['argument_resolver.request_payload'] ?? self::getArgumentResolver_RequestPayloadService($container)), 'onKernelControllerArguments'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'response_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ResponseListener')] fn () => ($container->privates['response_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\ResponseListener('UTF-8', false)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'setDefaultLocale'], 100);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'onKernelRequest'], 16);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'validate_request_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ValidateRequestListener')] fn () => ($container->privates['validate_request_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\ValidateRequestListener()), 'onKernelRequest'], 256);
        $instance->addListener('kernel.response', [#[\Closure(name: 'disallow_search_engine_index_response_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\DisallowRobotsIndexingListener')] fn () => ($container->privates['disallow_search_engine_index_response_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\DisallowRobotsIndexingListener()), 'onResponse'], -255);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'onControllerArguments'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'logKernelException'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'onKernelException'], -128);
        $instance->addListener('kernel.response', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'removeCspHeader'], -128);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'controller.cache_attribute_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\CacheAttributeListener')] fn () => ($container->privates['controller.cache_attribute_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\CacheAttributeListener()), 'onKernelControllerArguments'], 10);
        $instance->addListener('kernel.response', [#[\Closure(name: 'controller.cache_attribute_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\CacheAttributeListener')] fn () => ($container->privates['controller.cache_attribute_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\CacheAttributeListener()), 'onKernelResponse'], -10);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_aware_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleAwareListener')] fn () => ($container->privates['locale_aware_listener'] ?? self::getLocaleAwareListenerService($container)), 'onKernelRequest'], 15);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'locale_aware_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleAwareListener')] fn () => ($container->privates['locale_aware_listener'] ?? self::getLocaleAwareListenerService($container)), 'onKernelFinishRequest'], -15);
        $instance->addListener('console.error', [#[\Closure(name: 'console.error_listener', class: 'Symfony\\Component\\Console\\EventListener\\ErrorListener')] fn () => ($container->privates['console.error_listener'] ?? $container->load('getConsole_ErrorListenerService')), 'onConsoleError'], -128);
        $instance->addListener('console.terminate', [#[\Closure(name: 'console.error_listener', class: 'Symfony\\Component\\Console\\EventListener\\ErrorListener')] fn () => ($container->privates['console.error_listener'] ?? $container->load('getConsole_ErrorListenerService')), 'onConsoleTerminate'], -128);
        $instance->addListener('console.error', [#[\Closure(name: 'console.suggest_missing_package_subscriber', class: 'Symfony\\Bundle\\FrameworkBundle\\EventListener\\SuggestMissingPackageSubscriber')] fn () => ($container->privates['console.suggest_missing_package_subscriber'] ??= new \Symfony\Bundle\FrameworkBundle\EventListener\SuggestMissingPackageSubscriber()), 'onConsoleError'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'debug.debug_handlers_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\DebugHandlersListener')] fn () => ($container->privates['debug.debug_handlers_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener(NULL, $container->getEnv('bool:default::key:web:default:kernel.runtime_mode:'))), 'configure'], 2048);
        $instance->addListener('console.command', [#[\Closure(name: 'debug.debug_handlers_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\DebugHandlersListener')] fn () => ($container->privates['debug.debug_handlers_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener(NULL, $container->getEnv('bool:default::key:web:default:kernel.runtime_mode:'))), 'configure'], 2048);
        $instance->addListener('kernel.request', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelRequest'], 32);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelException'], -64);
        $instance->addListener('kernel.response', [#[\Closure(name: 'web_link.add_link_header_listener', class: 'Symfony\\Component\\WebLink\\EventListener\\AddLinkHeaderListener')] fn () => ($container->privates['web_link.add_link_header_listener'] ?? self::getWebLink_AddLinkHeaderListenerService($container)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'session_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\SessionListener')] fn () => ($container->privates['session_listener'] ?? self::getSessionListenerService($container)), 'onKernelRequest'], 128);
        $instance->addListener('kernel.response', [#[\Closure(name: 'session_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\SessionListener')] fn () => ($container->privates['session_listener'] ?? self::getSessionListenerService($container)), 'onKernelResponse'], -1000);
        $instance->addListener('kernel.view', [#[\Closure(name: 'controller.template_attribute_listener', class: 'Symfony\\Bridge\\Twig\\EventListener\\TemplateAttributeListener')] fn () => ($container->privates['controller.template_attribute_listener'] ?? $container->load('getController_TemplateAttributeListenerService')), 'onKernelView'], -128);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'controller.is_granted_attribute_listener', class: 'Symfony\\Component\\Security\\Http\\EventListener\\IsGrantedAttributeListener')] fn () => ($container->privates['controller.is_granted_attribute_listener'] ?? self::getController_IsGrantedAttributeListenerService($container)), 'onKernelControllerArguments'], 20);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.check_authenticator_credentials', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CheckCredentialsListener')] fn () => ($container->privates['security.listener.check_authenticator_credentials'] ?? $container->load('getSecurity_Listener_CheckAuthenticatorCredentialsService')), 'checkPassport'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'security.listener.password_migrating', class: 'Symfony\\Component\\Security\\Http\\EventListener\\PasswordMigratingListener')] fn () => ($container->privates['security.listener.password_migrating'] ?? $container->load('getSecurity_Listener_PasswordMigratingService')), 'onLoginSuccess'], 0);
        $instance->addListener('debug.security.authorization.vote', [#[\Closure(name: 'debug.security.voter.vote_listener', class: 'Symfony\\Bundle\\SecurityBundle\\EventListener\\VoteListener')] fn () => ($container->privates['debug.security.voter.vote_listener'] ?? $container->load('getDebug_Security_Voter_VoteListenerService')), 'onVoterVote'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'debug.security.firewall', class: 'Symfony\\Bundle\\SecurityBundle\\Debug\\TraceableFirewallListener')] fn () => ($container->privates['debug.security.firewall'] ?? self::getDebug_Security_FirewallService($container)), 'configureLogoutUrlGenerator'], 8);
        $instance->addListener('kernel.request', [#[\Closure(name: 'debug.security.firewall', class: 'Symfony\\Bundle\\SecurityBundle\\Debug\\TraceableFirewallListener')] fn () => ($container->privates['debug.security.firewall'] ?? self::getDebug_Security_FirewallService($container)), 'onKernelRequest'], 8);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'debug.security.firewall', class: 'Symfony\\Bundle\\SecurityBundle\\Debug\\TraceableFirewallListener')] fn () => ($container->privates['debug.security.firewall'] ?? self::getDebug_Security_FirewallService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('console.error', [#[\Closure(name: 'maker.console_error_listener', class: 'Symfony\\Bundle\\MakerBundle\\Event\\ConsoleErrorSubscriber')] fn () => ($container->privates['maker.console_error_listener'] ??= new \Symfony\Bundle\MakerBundle\Event\ConsoleErrorSubscriber()), 'onConsoleError'], 0);
        $instance->addListener('console.terminate', [#[\Closure(name: 'maker.console_error_listener', class: 'Symfony\\Bundle\\MakerBundle\\Event\\ConsoleErrorSubscriber')] fn () => ($container->privates['maker.console_error_listener'] ??= new \Symfony\Bundle\MakerBundle\Event\ConsoleErrorSubscriber()), 'onConsoleTerminate'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.csrf_protection', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfProtectionListener')] fn () => ($container->privates['security.listener.csrf_protection'] ?? $container->load('getSecurity_Listener_CsrfProtectionService')), 'checkPassport'], 512);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'security.logout.listener.csrf_token_clearing', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfTokenClearingLogoutListener')] fn () => ($container->privates['security.logout.listener.csrf_token_clearing'] ?? $container->load('getSecurity_Logout_Listener_CsrfTokenClearingService')), 'onLogout'], 0);

        return $instance;
    }

    /**
     * Gets the public 'http_kernel' shared service.
     *
     * @return \Symfony\Component\HttpKernel\HttpKernel
     */
    protected static function getHttpKernelService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['http_kernel'])) {
            return $container->services['http_kernel'];
        }
        $b = new \Symfony\Bundle\FrameworkBundle\Controller\ControllerResolver($container, ($container->privates['logger'] ?? self::getLoggerService($container)));
        $b->allowControllers(['Symfony\\Bundle\\FrameworkBundle\\Controller\\AbstractController', 'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController']);
        $b->allowControllers(['App\\Kernel', 'App\\Controller\\HomeController', 'Doctrine\\Bundle\\DoctrineBundle\\Controller\\ProfilerController']);
        $c = ($container->services['debug.stopwatch'] ??= new \Symfony\Component\Stopwatch\Stopwatch(true));

        return $container->services['http_kernel'] = new \Symfony\Component\HttpKernel\HttpKernel($a, new \Symfony\Component\HttpKernel\Controller\TraceableControllerResolver($b, $c), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), new \Symfony\Component\HttpKernel\Controller\TraceableArgumentResolver(new \Symfony\Component\HttpKernel\Controller\ArgumentResolver(new \Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadataFactory(), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['.debug.value_resolver.security.user_value_resolver'] ?? $container->load('get_Debug_ValueResolver_Security_UserValueResolverService'));
            yield 1 => ($container->privates['.debug.value_resolver.security.security_token_value_resolver'] ?? $container->load('get_Debug_ValueResolver_Security_SecurityTokenValueResolverService'));
            yield 2 => ($container->privates['.debug.value_resolver.doctrine.orm.entity_value_resolver'] ?? $container->load('get_Debug_ValueResolver_Doctrine_Orm_EntityValueResolverService'));
            yield 3 => ($container->privates['.debug.value_resolver.argument_resolver.backed_enum_resolver'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_BackedEnumResolverService'));
            yield 4 => ($container->privates['.debug.value_resolver.argument_resolver.datetime'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_DatetimeService'));
            yield 5 => ($container->privates['.debug.value_resolver.argument_resolver.request_attribute'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_RequestAttributeService'));
            yield 6 => ($container->privates['.debug.value_resolver.argument_resolver.request'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_RequestService'));
            yield 7 => ($container->privates['.debug.value_resolver.argument_resolver.session'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_SessionService'));
            yield 8 => ($container->privates['.debug.value_resolver.api_platform.argument_resolver.payload'] ?? $container->load('get_Debug_ValueResolver_ApiPlatform_ArgumentResolver_PayloadService'));
            yield 9 => ($container->privates['.debug.value_resolver.argument_resolver.service'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_ServiceService'));
            yield 10 => ($container->privates['.debug.value_resolver.argument_resolver.default'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_DefaultService'));
            yield 11 => ($container->privates['.debug.value_resolver.argument_resolver.variadic'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_VariadicService'));
            yield 12 => ($container->privates['.debug.value_resolver.argument_resolver.not_tagged_controller'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_NotTaggedControllerService'));
        }, 13), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'Symfony\\Bridge\\Doctrine\\ArgumentResolver\\EntityValueResolver' => ['privates', '.debug.value_resolver.doctrine.orm.entity_value_resolver', 'get_Debug_ValueResolver_Doctrine_Orm_EntityValueResolverService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\BackedEnumValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.backed_enum_resolver', 'get_Debug_ValueResolver_ArgumentResolver_BackedEnumResolverService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DateTimeValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.datetime', 'get_Debug_ValueResolver_ArgumentResolver_DatetimeService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.default', 'get_Debug_ValueResolver_ArgumentResolver_DefaultService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\QueryParameterValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.query_parameter_value_resolver', 'get_Debug_ValueResolver_ArgumentResolver_QueryParameterValueResolverService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.request_attribute', 'get_Debug_ValueResolver_ArgumentResolver_RequestAttributeService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.request_payload', 'get_Debug_ValueResolver_ArgumentResolver_RequestPayloadService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.request', 'get_Debug_ValueResolver_ArgumentResolver_RequestService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\ServiceValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.service', 'get_Debug_ValueResolver_ArgumentResolver_ServiceService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\SessionValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.session', 'get_Debug_ValueResolver_ArgumentResolver_SessionService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\VariadicValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.variadic', 'get_Debug_ValueResolver_ArgumentResolver_VariadicService', true],
            'Symfony\\Component\\Security\\Http\\Controller\\SecurityTokenValueResolver' => ['privates', '.debug.value_resolver.security.security_token_value_resolver', 'get_Debug_ValueResolver_Security_SecurityTokenValueResolverService', true],
            'Symfony\\Component\\Security\\Http\\Controller\\UserValueResolver' => ['privates', '.debug.value_resolver.security.user_value_resolver', 'get_Debug_ValueResolver_Security_UserValueResolverService', true],
            'api_platform.argument_resolver.payload' => ['privates', '.debug.value_resolver.api_platform.argument_resolver.payload', 'get_Debug_ValueResolver_ApiPlatform_ArgumentResolver_PayloadService', true],
            'argument_resolver.not_tagged_controller' => ['privates', '.debug.value_resolver.argument_resolver.not_tagged_controller', 'get_Debug_ValueResolver_ArgumentResolver_NotTaggedControllerService', true],
        ], [
            'Symfony\\Bridge\\Doctrine\\ArgumentResolver\\EntityValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\BackedEnumValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DateTimeValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\QueryParameterValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\ServiceValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\SessionValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\VariadicValueResolver' => '?',
            'Symfony\\Component\\Security\\Http\\Controller\\SecurityTokenValueResolver' => '?',
            'Symfony\\Component\\Security\\Http\\Controller\\UserValueResolver' => '?',
            'api_platform.argument_resolver.payload' => '?',
            'argument_resolver.not_tagged_controller' => '?',
        ])), $c), true);
    }

    /**
     * Gets the public 'request_stack' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\RequestStack
     */
    protected static function getRequestStackService($container)
    {
        return $container->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack();
    }

    /**
     * Gets the public 'router' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Routing\Router
     */
    protected static function getRouterService($container)
    {
        $container->services['router'] = $instance = new \Symfony\Bundle\FrameworkBundle\Routing\Router((new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'routing.loader' => ['services', 'routing.loader', 'getRouting_LoaderService', true],
        ], [
            'routing.loader' => 'Symfony\\Component\\Config\\Loader\\LoaderInterface',
        ]))->withContext('router.default', $container), 'kernel::loadRoutes', ['cache_dir' => $container->targetDir.'', 'debug' => true, 'generator_class' => 'Symfony\\Component\\Routing\\Generator\\CompiledUrlGenerator', 'generator_dumper_class' => 'Symfony\\Component\\Routing\\Generator\\Dumper\\CompiledUrlGeneratorDumper', 'matcher_class' => 'Symfony\\Bundle\\FrameworkBundle\\Routing\\RedirectableCompiledUrlMatcher', 'matcher_dumper_class' => 'Symfony\\Component\\Routing\\Matcher\\Dumper\\CompiledUrlMatcherDumper', 'strict_requirements' => true, 'resource_type' => 'service'], ($container->privates['router.request_context'] ?? self::getRouter_RequestContextService($container)), ($container->privates['parameter_bag'] ??= new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($container)), ($container->privates['logger'] ?? self::getLoggerService($container)), 'en');

        $instance->setConfigCacheFactory(new \Symfony\Component\Config\ResourceCheckerConfigCacheFactory(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['dependency_injection.config.container_parameters_resource_checker'] ??= new \Symfony\Component\DependencyInjection\Config\ContainerParametersResourceChecker($container));
            yield 1 => ($container->privates['config.resource.self_checking_resource_checker'] ??= new \Symfony\Component\Config\Resource\SelfCheckingResourceChecker());
        }, 2)));
        $instance->addExpressionLanguageProvider(($container->privates['router.expression_language_provider'] ?? self::getRouter_ExpressionLanguageProviderService($container)));

        return $instance;
    }

    /**
     * Gets the private '.service_locator.zJyh7qS' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected static function get_ServiceLocator_ZJyh7qSService($container)
    {
        return $container->privates['.service_locator.zJyh7qS'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'security.firewall.map.context.dev' => ['privates', 'security.firewall.map.context.dev', 'getSecurity_Firewall_Map_Context_DevService', true],
            'security.firewall.map.context.main' => ['privates', 'security.firewall.map.context.main', 'getSecurity_Firewall_Map_Context_MainService', true],
        ], [
            'security.firewall.map.context.dev' => '?',
            'security.firewall.map.context.main' => '?',
        ]);
    }

    /**
     * Gets the private 'api_platform.api.identifiers_extractor' shared service.
     *
     * @return \ApiPlatform\Metadata\IdentifiersExtractor
     */
    protected static function getApiPlatform_Api_IdentifiersExtractorService($container)
    {
        $a = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));

        if (isset($container->privates['api_platform.api.identifiers_extractor'])) {
            return $container->privates['api_platform.api.identifiers_extractor'];
        }

        return $container->privates['api_platform.api.identifiers_extractor'] = new \ApiPlatform\Metadata\IdentifiersExtractor($a, ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container)), ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)), ($container->privates['property_accessor'] ?? self::getPropertyAccessorService($container)));
    }

    /**
     * Gets the private 'api_platform.cache.metadata.property' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getApiPlatform_Cache_Metadata_PropertyService($container)
    {
        return $container->privates['api_platform.cache.metadata.property'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('C1NUIkiajp', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['logger'] ?? self::getLoggerService($container)));
    }

    /**
     * Gets the private 'api_platform.cache.metadata.resource' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getApiPlatform_Cache_Metadata_ResourceService($container)
    {
        return $container->privates['api_platform.cache.metadata.resource'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('VwRBoM2xVT', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['logger'] ?? self::getLoggerService($container)));
    }

    /**
     * Gets the private 'api_platform.cache.metadata.resource_collection' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getApiPlatform_Cache_Metadata_ResourceCollectionService($container)
    {
        return $container->privates['api_platform.cache.metadata.resource_collection'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('E+Z+-3RwMa', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['logger'] ?? self::getLoggerService($container)));
    }

    /**
     * Gets the private 'api_platform.filter_locator' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected static function getApiPlatform_FilterLocatorService($container)
    {
        return $container->privates['api_platform.filter_locator'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'annotated_app_entity_rpps_api_platform_doctrine_orm_filter_order_filter' => ['privates', 'annotated_app_entity_rpps_api_platform_doctrine_orm_filter_order_filter', 'getAnnotatedAppEntityRppsApiPlatformDoctrineOrmFilterOrderFilterService', true],
            'annotated_app_entity_speciality_api_platform_doctrine_orm_filter_order_filter' => ['privates', 'annotated_app_entity_speciality_api_platform_doctrine_orm_filter_order_filter', 'getAnnotatedAppEntitySpecialityApiPlatformDoctrineOrmFilterOrderFilterService', true],
            'annotated_app_entity_speciality_api_platform_doctrine_orm_filter_search_filter' => ['privates', 'annotated_app_entity_speciality_api_platform_doctrine_orm_filter_search_filter', 'getAnnotatedAppEntitySpecialityApiPlatformDoctrineOrmFilterSearchFilterService', true],
            'list.doctor.search' => ['privates', 'list.doctor.search', 'getList_Doctor_SearchService', true],
            'list.rpps.search' => ['privates', 'list.rpps.search', 'getList_Rpps_SearchService', true],
        ], [
            'annotated_app_entity_rpps_api_platform_doctrine_orm_filter_order_filter' => '?',
            'annotated_app_entity_speciality_api_platform_doctrine_orm_filter_order_filter' => '?',
            'annotated_app_entity_speciality_api_platform_doctrine_orm_filter_search_filter' => '?',
            'list.doctor.search' => '?',
            'list.rpps.search' => '?',
        ]);
    }

    /**
     * Gets the private 'api_platform.hydra.name_converter.hydra_prefix' shared service.
     *
     * @return \ApiPlatform\Hydra\Serializer\HydraPrefixNameConverter
     */
    protected static function getApiPlatform_Hydra_NameConverter_HydraPrefixService($container)
    {
        return $container->privates['api_platform.hydra.name_converter.hydra_prefix'] = new \ApiPlatform\Hydra\Serializer\HydraPrefixNameConverter(($container->privates['serializer.name_converter.metadata_aware'] ?? self::getSerializer_NameConverter_MetadataAwareService($container)));
    }

    /**
     * Gets the private 'api_platform.json_schema.backward_compatible_schema_factory' shared service.
     *
     * @return \ApiPlatform\JsonSchema\BackwardCompatibleSchemaFactory
     */
    protected static function getApiPlatform_JsonSchema_BackwardCompatibleSchemaFactoryService($container)
    {
        $a = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));

        if (isset($container->privates['api_platform.json_schema.backward_compatible_schema_factory'])) {
            return $container->privates['api_platform.json_schema.backward_compatible_schema_factory'];
        }
        $b = ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container));

        $c = new \ApiPlatform\JsonSchema\TypeFactory($b);

        $container->privates['api_platform.json_schema.backward_compatible_schema_factory'] = $instance = new \ApiPlatform\JsonSchema\BackwardCompatibleSchemaFactory(new \ApiPlatform\Hydra\JsonSchema\SchemaFactory(new \ApiPlatform\JsonSchema\SchemaFactory($c, $a, ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)), ($container->privates['api_platform.hydra.name_converter.hydra_prefix'] ?? self::getApiPlatform_Hydra_NameConverter_HydraPrefixService($container)), $b, $container->parameters['api_platform.jsonschema_formats'], new \ApiPlatform\JsonSchema\DefinitionNameFactory($container->parameters['api_platform.jsonschema_formats'])), $container->parameters['api_platform.serializer.default_context']));

        $c->setSchemaFactory($instance);

        return $instance;
    }

    /**
     * Gets the private 'api_platform.jsonld.context_builder' shared service.
     *
     * @return \ApiPlatform\JsonLd\ContextBuilder
     */
    protected static function getApiPlatform_Jsonld_ContextBuilderService($container)
    {
        return $container->privates['api_platform.jsonld.context_builder'] = new \ApiPlatform\JsonLd\ContextBuilder(($container->privates['api_platform.metadata.resource.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)), ($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container)), ($container->privates['api_platform.symfony.iri_converter.skolem'] ?? self::getApiPlatform_Symfony_IriConverter_SkolemService($container)), ($container->privates['api_platform.hydra.name_converter.hydra_prefix'] ?? self::getApiPlatform_Hydra_NameConverter_HydraPrefixService($container)), $container->parameters['api_platform.serializer.default_context']);
    }

    /**
     * Gets the private 'api_platform.listener.request.add_format' shared service.
     *
     * @return \ApiPlatform\Symfony\EventListener\AddFormatListener
     */
    protected static function getApiPlatform_Listener_Request_AddFormatService($container)
    {
        return $container->privates['api_platform.listener.request.add_format'] = new \ApiPlatform\Symfony\EventListener\AddFormatListener(new \ApiPlatform\State\Provider\ContentNegotiationProvider(NULL, ($container->privates['api_platform.negotiator'] ??= new \Negotiation\Negotiator()), $container->parameters['api_platform.formats'], $container->parameters['api_platform.error_formats']), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)));
    }

    /**
     * Gets the private 'api_platform.listener.request.deserialize' shared service.
     *
     * @return \ApiPlatform\Symfony\EventListener\DeserializeListener
     */
    protected static function getApiPlatform_Listener_Request_DeserializeService($container)
    {
        $a = ($container->privates['serializer'] ?? self::getSerializerService($container));

        if (isset($container->privates['api_platform.listener.request.deserialize'])) {
            return $container->privates['api_platform.listener.request.deserialize'];
        }
        $b = ($container->privates['api_platform.security.resource_access_checker'] ?? self::getApiPlatform_Security_ResourceAccessCheckerService($container));

        if (isset($container->privates['api_platform.listener.request.deserialize'])) {
            return $container->privates['api_platform.listener.request.deserialize'];
        }

        return $container->privates['api_platform.listener.request.deserialize'] = new \ApiPlatform\Symfony\EventListener\DeserializeListener(new \ApiPlatform\Symfony\Security\State\AccessCheckerProvider(new \ApiPlatform\State\Provider\DeserializeProvider(NULL, $a, ($container->privates['api_platform.openapi.serializer_context_builder'] ?? self::getApiPlatform_Openapi_SerializerContextBuilderService($container)), NULL), $b, 'post_denormalize'), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)));
    }

    /**
     * Gets the private 'api_platform.listener.request.read' shared service.
     *
     * @return \ApiPlatform\Symfony\EventListener\ReadListener
     */
    protected static function getApiPlatform_Listener_Request_ReadService($container)
    {
        $a = ($container->privates['api_platform.security.resource_access_checker'] ?? self::getApiPlatform_Security_ResourceAccessCheckerService($container));

        if (isset($container->privates['api_platform.listener.request.read'])) {
            return $container->privates['api_platform.listener.request.read'];
        }

        return $container->privates['api_platform.listener.request.read'] = new \ApiPlatform\Symfony\EventListener\ReadListener(new \ApiPlatform\State\Provider\SecurityParameterProvider(new \ApiPlatform\Symfony\Security\State\AccessCheckerProvider(new \ApiPlatform\Symfony\Bundle\SwaggerUi\SwaggerUiProvider(new \ApiPlatform\State\Provider\ParameterProvider(($container->services['api_platform.state_provider.parameter_validator'] ?? self::getApiPlatform_StateProvider_ParameterValidatorService($container)), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'api_platform.serializer.filter_parameter_provider' => ['privates', 'api_platform.serializer.filter_parameter_provider', 'getApiPlatform_Serializer_FilterParameterProviderService', true],
        ], [
            'api_platform.serializer.filter_parameter_provider' => 'ApiPlatform\\Serializer\\Parameter\\SerializerFilterParameterProvider',
        ])), ($container->privates['api_platform.openapi.factory'] ?? self::getApiPlatform_Openapi_FactoryService($container))), $a), $a), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)), NULL, ($container->privates['api_platform.uri_variables.converter'] ?? self::getApiPlatform_UriVariables_ConverterService($container)));
    }

    /**
     * Gets the private 'api_platform.listener.view.validate_query_parameters' shared service.
     *
     * @return \ApiPlatform\Symfony\EventListener\QueryParameterValidateListener
     */
    protected static function getApiPlatform_Listener_View_ValidateQueryParametersService($container)
    {
        return $container->privates['api_platform.listener.view.validate_query_parameters'] = new \ApiPlatform\Symfony\EventListener\QueryParameterValidateListener($container->load('getApiPlatform_Validator_QueryParameterValidatorService'), ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)));
    }

    /**
     * Gets the private 'api_platform.metadata.operation.metadata_factory' shared service.
     *
     * @return \ApiPlatform\Metadata\Operation\Factory\OperationMetadataFactory
     */
    protected static function getApiPlatform_Metadata_Operation_MetadataFactoryService($container)
    {
        $a = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));

        if (isset($container->privates['api_platform.metadata.operation.metadata_factory'])) {
            return $container->privates['api_platform.metadata.operation.metadata_factory'];
        }

        return $container->privates['api_platform.metadata.operation.metadata_factory'] = new \ApiPlatform\Metadata\Operation\Factory\OperationMetadataFactory(($container->privates['api_platform.metadata.resource.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)), $a);
    }

    /**
     * Gets the private 'api_platform.metadata.property.metadata_factory.cached' shared service.
     *
     * @return \ApiPlatform\Metadata\Property\Factory\CachedPropertyMetadataFactory
     */
    protected static function getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)
    {
        $a = ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container));

        return $container->privates['api_platform.metadata.property.metadata_factory.cached'] = new \ApiPlatform\Metadata\Property\Factory\CachedPropertyMetadataFactory(($container->privates['api_platform.cache.metadata.property'] ?? self::getApiPlatform_Cache_Metadata_PropertyService($container)), new \ApiPlatform\JsonSchema\Metadata\Property\Factory\SchemaPropertyMetadataFactory($a, new \ApiPlatform\Symfony\Validator\Metadata\Property\ValidatorPropertyMetadataFactory(($container->privates['validator'] ?? self::getValidatorService($container)), new \ApiPlatform\Metadata\Property\Factory\ExtractorPropertyMetadataFactory(($container->privates['api_platform.metadata.property_extractor.yaml'] ??= new \ApiPlatform\Metadata\Extractor\YamlPropertyExtractor([], $container)), new \ApiPlatform\Metadata\Property\Factory\AttributePropertyMetadataFactory(new \ApiPlatform\Metadata\Property\Factory\IdentifierPropertyMetadataFactory($a, new \ApiPlatform\Metadata\Property\Factory\DefaultPropertyMetadataFactory(new \ApiPlatform\Metadata\Property\Factory\SerializerPropertyMetadataFactory(($container->privates['api_platform.serializer.mapping.class_metadata_factory'] ?? self::getApiPlatform_Serializer_Mapping_ClassMetadataFactoryService($container)), new \ApiPlatform\Doctrine\Orm\Metadata\Property\DoctrineOrmPropertyMetadataFactory(($container->services['doctrine'] ?? self::getDoctrineService($container)), new \ApiPlatform\Metadata\Property\Factory\PropertyInfoPropertyMetadataFactory(($container->privates['property_info'] ?? self::getPropertyInfoService($container)), new \ApiPlatform\Metadata\Property\Factory\ExtractorPropertyMetadataFactory(($container->privates['api_platform.metadata.property_extractor.xml'] ??= new \ApiPlatform\Metadata\Extractor\XmlPropertyExtractor([], $container))))), $a))))), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['api_platform.metadata.property_schema.choice_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaChoiceRestriction());
            yield 1 => ($container->privates['api_platform.metadata.property_schema.collection_restriction'] ?? $container->load('getApiPlatform_Metadata_PropertySchema_CollectionRestrictionService'));
            yield 2 => ($container->privates['api_platform.metadata.property_schema.count_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaCountRestriction());
            yield 3 => ($container->privates['api_platform.metadata.property_schema.greater_than_or_equal_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaGreaterThanOrEqualRestriction());
            yield 4 => ($container->privates['api_platform.metadata.property_schema.greater_than_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaGreaterThanRestriction());
            yield 5 => ($container->privates['api_platform.metadata.property_schema.length_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaLengthRestriction());
            yield 6 => ($container->privates['api_platform.metadata.property_schema.less_than_or_equal_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaLessThanOrEqualRestriction());
            yield 7 => ($container->privates['api_platform.metadata.property_schema.less_than_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaLessThanRestriction());
            yield 8 => ($container->privates['api_platform.metadata.property_schema.one_of_restriction'] ?? $container->load('getApiPlatform_Metadata_PropertySchema_OneOfRestrictionService'));
            yield 9 => ($container->privates['api_platform.metadata.property_schema.range_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaRangeRestriction());
            yield 10 => ($container->privates['api_platform.metadata.property_schema.regex_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaRegexRestriction());
            yield 11 => ($container->privates['api_platform.metadata.property_schema.format_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaFormat());
            yield 12 => ($container->privates['api_platform.metadata.property_schema.unique_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaUniqueRestriction());
        }, 13))));
    }

    /**
     * Gets the private 'api_platform.metadata.property.name_collection_factory.cached' shared service.
     *
     * @return \ApiPlatform\Metadata\Property\Factory\CachedPropertyNameCollectionFactory
     */
    protected static function getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container)
    {
        return $container->privates['api_platform.metadata.property.name_collection_factory.cached'] = new \ApiPlatform\Metadata\Property\Factory\CachedPropertyNameCollectionFactory(($container->privates['api_platform.cache.metadata.property'] ?? self::getApiPlatform_Cache_Metadata_PropertyService($container)), new \ApiPlatform\Metadata\Property\Factory\ExtractorPropertyNameCollectionFactory(($container->privates['api_platform.metadata.property_extractor.yaml'] ??= new \ApiPlatform\Metadata\Extractor\YamlPropertyExtractor([], $container)), new \ApiPlatform\Metadata\Property\Factory\ConcernsPropertyNameCollectionMetadataFactory(new \ApiPlatform\Metadata\Property\Factory\ExtractorPropertyNameCollectionFactory(($container->privates['api_platform.metadata.property_extractor.xml'] ??= new \ApiPlatform\Metadata\Extractor\XmlPropertyExtractor([], $container)), new \ApiPlatform\Metadata\Property\Factory\PropertyInfoPropertyNameCollectionFactory(($container->privates['property_info'] ?? self::getPropertyInfoService($container)))))));
    }

    /**
     * Gets the private 'api_platform.metadata.resource.metadata_collection_factory.cached' shared service.
     *
     * @return \ApiPlatform\Metadata\Resource\Factory\CachedResourceMetadataCollectionFactory
     */
    protected static function getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)
    {
        $a = ($container->privates['api_platform.filter_locator'] ?? self::getApiPlatform_FilterLocatorService($container));

        if (isset($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'])) {
            return $container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'];
        }
        $b = ($container->services['doctrine'] ?? self::getDoctrineService($container));
        $c = ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container));
        $d = ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container));

        $e = new \ApiPlatform\Doctrine\Orm\Metadata\Resource\DoctrineOrmLinkFactory($b, $c, $d, new \ApiPlatform\Metadata\Resource\Factory\LinkFactory($c, ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)), $d));
        $f = ($container->privates['logger'] ?? self::getLoggerService($container));

        return $container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] = new \ApiPlatform\Metadata\Resource\Factory\CachedResourceMetadataCollectionFactory(($container->privates['api_platform.cache.metadata.resource_collection'] ?? self::getApiPlatform_Cache_Metadata_ResourceCollectionService($container)), new \ApiPlatform\Doctrine\Orm\Metadata\Resource\DoctrineOrmResourceCollectionMetadataFactory($b, new \ApiPlatform\Metadata\Resource\Factory\PhpDocResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\AlternateUriResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\FiltersResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\FormatsResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\InputOutputResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\OperationNameResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\LinkResourceMetadataCollectionFactory($e, new \ApiPlatform\Metadata\Resource\Factory\MainControllerResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\UriTemplateResourceMetadataCollectionFactory($e, new \ApiPlatform\Metadata\Operation\UnderscorePathSegmentNameGenerator(new \ApiPlatform\Metadata\Util\Inflector(false)), new \ApiPlatform\Metadata\Resource\Factory\BackedEnumResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\NotExposedOperationResourceMetadataCollectionFactory($e, new \ApiPlatform\Metadata\Resource\Factory\ExtractorResourceMetadataCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.yaml'] ??= new \ApiPlatform\Metadata\Extractor\YamlResourceExtractor([], $container)), new \ApiPlatform\Metadata\Resource\Factory\ConcernsResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\ExtractorResourceMetadataCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.xml'] ??= new \ApiPlatform\Metadata\Extractor\XmlResourceExtractor([], $container)), new \ApiPlatform\Metadata\Resource\Factory\ParameterResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\DeprecationResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\AttributesResourceMetadataCollectionFactory(NULL, $f, $container->parameters['api_platform.defaults'], false)), $a, ($container->privates['api_platform.hydra.name_converter.hydra_prefix'] ?? self::getApiPlatform_Hydra_NameConverter_HydraPrefixService($container))), $container->parameters['api_platform.defaults'], $f, false)), $container->parameters['api_platform.defaults'], $f, false)))), true)))), $container->parameters['api_platform.formats'], $container->parameters['api_platform.patch_formats'], $container->parameters['api_platform.error_formats']))))));
    }

    /**
     * Gets the private 'api_platform.metadata.resource.name_collection_factory.cached' shared service.
     *
     * @return \ApiPlatform\Metadata\Resource\Factory\CachedResourceNameCollectionFactory
     */
    protected static function getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)
    {
        return $container->privates['api_platform.metadata.resource.name_collection_factory.cached'] = new \ApiPlatform\Metadata\Resource\Factory\CachedResourceNameCollectionFactory(($container->privates['api_platform.cache.metadata.resource'] ?? self::getApiPlatform_Cache_Metadata_ResourceService($container)), new \ApiPlatform\Metadata\Resource\Factory\ExtractorResourceNameCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.yaml'] ??= new \ApiPlatform\Metadata\Extractor\YamlResourceExtractor([], $container)), new \ApiPlatform\Metadata\Resource\Factory\ClassNameResourceNameCollectionFactory($container->parameters['api_platform.class_name_resources'], new \ApiPlatform\Metadata\Resource\Factory\AttributesResourceNameCollectionFactory($container->parameters['api_platform.resource_class_directories'], new \ApiPlatform\Metadata\Resource\Factory\ConcernsResourceNameCollectionFactory($container->parameters['api_platform.resource_class_directories'], new \ApiPlatform\Metadata\Resource\Factory\ExtractorResourceNameCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.xml'] ??= new \ApiPlatform\Metadata\Extractor\XmlResourceExtractor([], $container))))))));
    }

    /**
     * Gets the private 'api_platform.openapi.factory' shared service.
     *
     * @return \ApiPlatform\OpenApi\Factory\OpenApiFactory
     */
    protected static function getApiPlatform_Openapi_FactoryService($container)
    {
        $a = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));

        if (isset($container->privates['api_platform.openapi.factory'])) {
            return $container->privates['api_platform.openapi.factory'];
        }
        $b = ($container->privates['api_platform.json_schema.backward_compatible_schema_factory'] ?? self::getApiPlatform_JsonSchema_BackwardCompatibleSchemaFactoryService($container));

        if (isset($container->privates['api_platform.openapi.factory'])) {
            return $container->privates['api_platform.openapi.factory'];
        }
        $c = ($container->privates['api_platform.filter_locator'] ?? self::getApiPlatform_FilterLocatorService($container));

        if (isset($container->privates['api_platform.openapi.factory'])) {
            return $container->privates['api_platform.openapi.factory'];
        }
        $d = ($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container));

        if (isset($container->privates['api_platform.openapi.factory'])) {
            return $container->privates['api_platform.openapi.factory'];
        }

        return $container->privates['api_platform.openapi.factory'] = new \ApiPlatform\OpenApi\Factory\OpenApiFactory(($container->privates['api_platform.metadata.resource.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)), $a, ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container)), ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)), $b, NULL, $c, $container->parameters['api_platform.formats'], ($container->privates['api_platform.openapi.options'] ?? self::getApiPlatform_Openapi_OptionsService($container)), new \ApiPlatform\State\Pagination\PaginationOptions(true, 'page', false, 'itemsPerPage', false, 'pagination', 30, NULL, false, false, 'partial'), $d);
    }

    /**
     * Gets the private 'api_platform.openapi.options' shared service.
     *
     * @return \ApiPlatform\OpenApi\Options
     */
    protected static function getApiPlatform_Openapi_OptionsService($container)
    {
        return $container->privates['api_platform.openapi.options'] = new \ApiPlatform\OpenApi\Options('Hello API Platform', '', '1.0.0', false, 'oauth2', 'application', '', '', '', [], [], NULL, NULL, NULL, NULL, NULL, NULL, true);
    }

    /**
     * Gets the private 'api_platform.openapi.serializer_context_builder' shared service.
     *
     * @return \ApiPlatform\OpenApi\Serializer\SerializerContextBuilder
     */
    protected static function getApiPlatform_Openapi_SerializerContextBuilderService($container)
    {
        $a = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));

        return $container->privates['api_platform.openapi.serializer_context_builder'] = new \ApiPlatform\OpenApi\Serializer\SerializerContextBuilder(new \ApiPlatform\Serializer\SerializerFilterContextBuilder($a, ($container->privates['api_platform.filter_locator'] ?? self::getApiPlatform_FilterLocatorService($container)), new \ApiPlatform\Serializer\SerializerContextBuilder($a, true)));
    }

    /**
     * Gets the private 'api_platform.resource_class_resolver' shared service.
     *
     * @return \ApiPlatform\Metadata\ResourceClassResolver
     */
    protected static function getApiPlatform_ResourceClassResolverService($container)
    {
        return $container->privates['api_platform.resource_class_resolver'] = new \ApiPlatform\Metadata\ResourceClassResolver(($container->privates['api_platform.metadata.resource.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)));
    }

    /**
     * Gets the private 'api_platform.router' shared service.
     *
     * @return \ApiPlatform\Symfony\Routing\Router
     */
    protected static function getApiPlatform_RouterService($container)
    {
        $a = ($container->services['router'] ?? self::getRouterService($container));

        if (isset($container->privates['api_platform.router'])) {
            return $container->privates['api_platform.router'];
        }

        return $container->privates['api_platform.router'] = new \ApiPlatform\Symfony\Routing\Router($a, 1);
    }

    /**
     * Gets the private 'api_platform.security.resource_access_checker' shared service.
     *
     * @return \ApiPlatform\Symfony\Security\ResourceAccessChecker
     */
    protected static function getApiPlatform_Security_ResourceAccessCheckerService($container)
    {
        $a = ($container->privates['security.authorization_checker'] ?? self::getSecurity_AuthorizationCheckerService($container));

        if (isset($container->privates['api_platform.security.resource_access_checker'])) {
            return $container->privates['api_platform.security.resource_access_checker'];
        }

        return $container->privates['api_platform.security.resource_access_checker'] = new \ApiPlatform\Symfony\Security\ResourceAccessChecker(($container->privates['security.expression_language'] ?? self::getSecurity_ExpressionLanguageService($container)), ($container->privates['security.authentication.trust_resolver'] ??= new \Symfony\Component\Security\Core\Authentication\AuthenticationTrustResolver()), ($container->privates['security.role_hierarchy'] ??= new \Symfony\Component\Security\Core\Role\RoleHierarchy([])), ($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), $a, false);
    }

    /**
     * Gets the private 'api_platform.serializer.mapping.class_metadata_factory' shared service.
     *
     * @return \ApiPlatform\Serializer\Mapping\Factory\ClassMetadataFactory
     */
    protected static function getApiPlatform_Serializer_Mapping_ClassMetadataFactoryService($container)
    {
        return $container->privates['api_platform.serializer.mapping.class_metadata_factory'] = new \ApiPlatform\Serializer\Mapping\Factory\ClassMetadataFactory(new \Symfony\Component\Serializer\Mapping\Factory\ClassMetadataFactory(new \Symfony\Component\Serializer\Mapping\Loader\LoaderChain([new \Symfony\Component\Serializer\Mapping\Loader\AttributeLoader(NULL)])));
    }

    /**
     * Gets the private 'api_platform.state_provider.locator' shared service.
     *
     * @return \ApiPlatform\State\CallableProvider
     */
    protected static function getApiPlatform_StateProvider_LocatorService($container)
    {
        return $container->privates['api_platform.state_provider.locator'] = new \ApiPlatform\State\CallableProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'ApiPlatform\\Doctrine\\Orm\\State\\CollectionProvider' => ['privates', 'api_platform.doctrine.orm.state.collection_provider', 'getApiPlatform_Doctrine_Orm_State_CollectionProviderService', true],
            'ApiPlatform\\Doctrine\\Orm\\State\\ItemProvider' => ['privates', 'api_platform.doctrine.orm.state.item_provider', 'getApiPlatform_Doctrine_Orm_State_ItemProviderService', true],
            'ApiPlatform\\OpenApi\\State\\OpenApiProvider' => ['privates', 'api_platform.openapi.provider', 'getApiPlatform_Openapi_ProviderService', true],
            'ApiPlatform\\State\\CreateProvider' => ['privates', 'api_platform.state_provider.create', 'getApiPlatform_StateProvider_CreateService', true],
            'ApiPlatform\\State\\ObjectProvider' => ['privates', 'api_platform.state_provider.object', 'getApiPlatform_StateProvider_ObjectService', true],
            'App\\State\\AddressProvider' => ['privates', 'App\\State\\AddressProvider', 'getAddressProviderService', true],
            'App\\State\\DepartmentStateProvider' => ['privates', 'App\\State\\DepartmentStateProvider', 'getDepartmentStateProviderService', true],
            'App\\State\\InseeRefStateProvider' => ['privates', 'App\\State\\InseeRefStateProvider', 'getInseeRefStateProviderService', true],
            'App\\State\\RppsProvider' => ['privates', 'App\\State\\RppsProvider', 'getRppsProviderService', true],
            'App\\State\\SirenProvider' => ['privates', 'App\\State\\SirenProvider', 'getSirenProviderService', true],
            'api_platform.doctrine.orm.state.collection_provider' => ['privates', 'api_platform.doctrine.orm.state.collection_provider', 'getApiPlatform_Doctrine_Orm_State_CollectionProviderService', true],
            'api_platform.doctrine.orm.state.item_provider' => ['privates', 'api_platform.doctrine.orm.state.item_provider', 'getApiPlatform_Doctrine_Orm_State_ItemProviderService', true],
            'api_platform.openapi.provider' => ['privates', 'api_platform.openapi.provider', 'getApiPlatform_Openapi_ProviderService', true],
            'api_platform.state.error_provider' => ['privates', 'api_platform.state.error_provider', 'getApiPlatform_State_ErrorProviderService', true],
            'api_platform.state_provider.create' => ['privates', 'api_platform.state_provider.create', 'getApiPlatform_StateProvider_CreateService', true],
            'api_platform.state_provider.object' => ['privates', 'api_platform.state_provider.object', 'getApiPlatform_StateProvider_ObjectService', true],
            'api_platform.validator.state.error_provider' => ['privates', 'api_platform.validator.state.error_provider', 'getApiPlatform_Validator_State_ErrorProviderService', true],
        ], [
            'ApiPlatform\\Doctrine\\Orm\\State\\CollectionProvider' => 'ApiPlatform\\Doctrine\\Orm\\State\\CollectionProvider',
            'ApiPlatform\\Doctrine\\Orm\\State\\ItemProvider' => 'ApiPlatform\\Doctrine\\Orm\\State\\ItemProvider',
            'ApiPlatform\\OpenApi\\State\\OpenApiProvider' => 'ApiPlatform\\OpenApi\\State\\OpenApiProvider',
            'ApiPlatform\\State\\CreateProvider' => 'ApiPlatform\\State\\CreateProvider',
            'ApiPlatform\\State\\ObjectProvider' => 'ApiPlatform\\State\\ObjectProvider',
            'App\\State\\AddressProvider' => 'App\\State\\AddressProvider',
            'App\\State\\DepartmentStateProvider' => 'App\\State\\DepartmentStateProvider',
            'App\\State\\InseeRefStateProvider' => 'App\\State\\InseeRefStateProvider',
            'App\\State\\RppsProvider' => 'App\\State\\RppsProvider',
            'App\\State\\SirenProvider' => 'App\\State\\SirenProvider',
            'api_platform.doctrine.orm.state.collection_provider' => 'ApiPlatform\\Doctrine\\Orm\\State\\CollectionProvider',
            'api_platform.doctrine.orm.state.item_provider' => 'ApiPlatform\\Doctrine\\Orm\\State\\ItemProvider',
            'api_platform.openapi.provider' => 'ApiPlatform\\OpenApi\\State\\OpenApiProvider',
            'api_platform.state.error_provider' => 'ApiPlatform\\State\\ErrorProvider',
            'api_platform.state_provider.create' => 'ApiPlatform\\State\\CreateProvider',
            'api_platform.state_provider.object' => 'ApiPlatform\\State\\ObjectProvider',
            'api_platform.validator.state.error_provider' => 'ApiPlatform\\Symfony\\Validator\\State\\ErrorProvider',
        ]));
    }

    /**
     * Gets the private 'api_platform.symfony.iri_converter' shared service.
     *
     * @return \ApiPlatform\Symfony\Routing\IriConverter
     */
    protected static function getApiPlatform_Symfony_IriConverterService($container)
    {
        $a = ($container->privates['api_platform.state_provider.locator'] ?? self::getApiPlatform_StateProvider_LocatorService($container));

        if (isset($container->privates['api_platform.symfony.iri_converter'])) {
            return $container->privates['api_platform.symfony.iri_converter'];
        }
        $b = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));

        if (isset($container->privates['api_platform.symfony.iri_converter'])) {
            return $container->privates['api_platform.symfony.iri_converter'];
        }
        $c = ($container->privates['api_platform.uri_variables.converter'] ?? self::getApiPlatform_UriVariables_ConverterService($container));

        if (isset($container->privates['api_platform.symfony.iri_converter'])) {
            return $container->privates['api_platform.symfony.iri_converter'];
        }
        $d = ($container->privates['api_platform.metadata.operation.metadata_factory'] ?? self::getApiPlatform_Metadata_Operation_MetadataFactoryService($container));

        if (isset($container->privates['api_platform.symfony.iri_converter'])) {
            return $container->privates['api_platform.symfony.iri_converter'];
        }

        return $container->privates['api_platform.symfony.iri_converter'] = new \ApiPlatform\Symfony\Routing\IriConverter($a, ($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container)), ($container->privates['api_platform.api.identifiers_extractor'] ?? self::getApiPlatform_Api_IdentifiersExtractorService($container)), ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container)), $b, $c, ($container->privates['api_platform.symfony.iri_converter.skolem'] ?? self::getApiPlatform_Symfony_IriConverter_SkolemService($container)), $d);
    }

    /**
     * Gets the private 'api_platform.symfony.iri_converter.skolem' shared service.
     *
     * @return \ApiPlatform\Symfony\Routing\SkolemIriConverter
     */
    protected static function getApiPlatform_Symfony_IriConverter_SkolemService($container)
    {
        return $container->privates['api_platform.symfony.iri_converter.skolem'] = new \ApiPlatform\Symfony\Routing\SkolemIriConverter(($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container)));
    }

    /**
     * Gets the private 'api_platform.uri_variables.converter' shared service.
     *
     * @return \ApiPlatform\Metadata\UriVariablesConverter
     */
    protected static function getApiPlatform_UriVariables_ConverterService($container)
    {
        $a = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));

        if (isset($container->privates['api_platform.uri_variables.converter'])) {
            return $container->privates['api_platform.uri_variables.converter'];
        }

        return $container->privates['api_platform.uri_variables.converter'] = new \ApiPlatform\Metadata\UriVariablesConverter(($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)), $a, new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['api_platform.uri_variables.transformer.integer'] ??= new \ApiPlatform\Metadata\UriVariableTransformer\IntegerUriVariableTransformer());
            yield 1 => ($container->privates['api_platform.uri_variables.transformer.date_time'] ??= new \ApiPlatform\Metadata\UriVariableTransformer\DateTimeUriVariableTransformer());
        }, 2));
    }

    /**
     * Gets the private 'argument_resolver.request_payload' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestPayloadValueResolver
     */
    protected static function getArgumentResolver_RequestPayloadService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['argument_resolver.request_payload'] = $container->createProxy('RequestPayloadValueResolverGhost3590451', static fn () => \RequestPayloadValueResolverGhost3590451::createLazyGhost(static fn ($proxy) => self::getArgumentResolver_RequestPayloadService($container, $proxy)));
        }

        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ValueResolverInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestPayloadValueResolver.php';

        return ($lazyLoad->__construct(($container->privates['serializer'] ?? self::getSerializerService($container)), ($container->privates['validator'] ?? self::getValidatorService($container)), NULL) && false ?: $lazyLoad);
    }

    /**
     * Gets the private 'cache.security_expression_language' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_SecurityExpressionLanguageService($container)
    {
        return $container->privates['cache.security_expression_language'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('WNwu+4iBfO', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['logger'] ?? self::getLoggerService($container)));
    }

    /**
     * Gets the private 'controller.is_granted_attribute_listener' shared service.
     *
     * @return \Symfony\Component\Security\Http\EventListener\IsGrantedAttributeListener
     */
    protected static function getController_IsGrantedAttributeListenerService($container)
    {
        $a = ($container->privates['security.authorization_checker'] ?? self::getSecurity_AuthorizationCheckerService($container));

        if (isset($container->privates['controller.is_granted_attribute_listener'])) {
            return $container->privates['controller.is_granted_attribute_listener'];
        }

        return $container->privates['controller.is_granted_attribute_listener'] = new \Symfony\Component\Security\Http\EventListener\IsGrantedAttributeListener($a, new \Symfony\Component\ExpressionLanguage\ExpressionLanguage(($container->services['cache.security_is_granted_attribute_expression_language'] ?? self::getCache_SecurityIsGrantedAttributeExpressionLanguageService($container))));
    }

    /**
     * Gets the private 'debug.security.access.decision_manager' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\TraceableAccessDecisionManager
     */
    protected static function getDebug_Security_Access_DecisionManagerService($container)
    {
        return $container->privates['debug.security.access.decision_manager'] = new \Symfony\Component\Security\Core\Authorization\TraceableAccessDecisionManager(new \Symfony\Component\Security\Core\Authorization\AccessDecisionManager(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['.debug.security.voter.security.access.authenticated_voter'] ?? $container->load('get_Debug_Security_Voter_Security_Access_AuthenticatedVoterService'));
            yield 1 => ($container->privates['.debug.security.voter.security.access.simple_role_voter'] ?? $container->load('get_Debug_Security_Voter_Security_Access_SimpleRoleVoterService'));
            yield 2 => ($container->privates['.debug.security.voter.security.access.expression_voter'] ?? $container->load('get_Debug_Security_Voter_Security_Access_ExpressionVoterService'));
        }, 3), new \Symfony\Component\Security\Core\Authorization\Strategy\AffirmativeStrategy(false)));
    }

    /**
     * Gets the private 'debug.security.firewall' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\Debug\TraceableFirewallListener
     */
    protected static function getDebug_Security_FirewallService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->privates['debug.security.firewall'])) {
            return $container->privates['debug.security.firewall'];
        }

        return $container->privates['debug.security.firewall'] = new \Symfony\Bundle\SecurityBundle\Debug\TraceableFirewallListener(($container->privates['security.firewall.map'] ?? self::getSecurity_Firewall_MapService($container)), $a, ($container->privates['security.logout_url_generator'] ?? self::getSecurity_LogoutUrlGeneratorService($container)));
    }

    /**
     * Gets the private 'doctrine.dbal.default_connection.event_manager' shared service.
     *
     * @return \Symfony\Bridge\Doctrine\ContainerAwareEventManager
     */
    protected static function getDoctrine_Dbal_DefaultConnection_EventManagerService($container)
    {
        return $container->privates['doctrine.dbal.default_connection.event_manager'] = new \Symfony\Bridge\Doctrine\ContainerAwareEventManager(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'doctrine.orm.default_listeners.attach_entity_listeners' => ['privates', 'doctrine.orm.default_listeners.attach_entity_listeners', 'getDoctrine_Orm_DefaultListeners_AttachEntityListenersService', true],
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener' => ['privates', 'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener', 'getDoctrine_Orm_Listeners_DoctrineDbalCacheAdapterSchemaListenerService', true],
            'doctrine.orm.listeners.doctrine_token_provider_schema_listener' => ['privates', 'doctrine.orm.listeners.doctrine_token_provider_schema_listener', 'getDoctrine_Orm_Listeners_DoctrineTokenProviderSchemaListenerService', true],
            'doctrine.orm.listeners.lock_store_schema_listener' => ['privates', 'doctrine.orm.listeners.lock_store_schema_listener', 'getDoctrine_Orm_Listeners_LockStoreSchemaListenerService', true],
            'doctrine.orm.listeners.pdo_session_handler_schema_listener' => ['privates', 'doctrine.orm.listeners.pdo_session_handler_schema_listener', 'getDoctrine_Orm_Listeners_PdoSessionHandlerSchemaListenerService', true],
        ], [
            'doctrine.orm.default_listeners.attach_entity_listeners' => '?',
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener' => '?',
            'doctrine.orm.listeners.doctrine_token_provider_schema_listener' => '?',
            'doctrine.orm.listeners.lock_store_schema_listener' => '?',
            'doctrine.orm.listeners.pdo_session_handler_schema_listener' => '?',
        ]), [[['postGenerateSchema'], 'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.doctrine_token_provider_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.pdo_session_handler_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.lock_store_schema_listener'], [['loadClassMetadata'], 'doctrine.orm.default_listeners.attach_entity_listeners']]);
    }

    /**
     * Gets the private 'doctrine.orm.default_configuration' shared service.
     *
     * @return \Doctrine\ORM\Configuration
     */
    protected static function getDoctrine_Orm_DefaultConfigurationService($container)
    {
        $container->privates['doctrine.orm.default_configuration'] = $instance = new \Doctrine\ORM\Configuration();

        $a = new \Doctrine\Persistence\Mapping\Driver\MappingDriverChain();
        $a->addDriver(($container->privates['doctrine.orm.default_attribute_metadata_driver'] ??= new \Doctrine\ORM\Mapping\Driver\AttributeDriver([(\dirname(__DIR__, 4).'/src/Entity')], true)), 'App\\Entity');

        $instance->setEntityNamespaces(['App' => 'App\\Entity']);
        $instance->setMetadataCache(new \Symfony\Component\Cache\Adapter\ArrayAdapter());
        $instance->setQueryCache(($container->privates['cache.doctrine.orm.default.query'] ??= new \Symfony\Component\Cache\Adapter\ArrayAdapter()));
        $instance->setResultCache(($container->privates['cache.doctrine.orm.default.result'] ??= new \Symfony\Component\Cache\Adapter\ArrayAdapter()));
        $instance->setMetadataDriverImpl(new \Doctrine\Bundle\DoctrineBundle\Mapping\MappingDriver($a, new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'doctrine.ulid_generator' => ['privates', 'doctrine.ulid_generator', 'getDoctrine_UlidGeneratorService', true],
            'doctrine.uuid_generator' => ['privates', 'doctrine.uuid_generator', 'getDoctrine_UuidGeneratorService', true],
        ], [
            'doctrine.ulid_generator' => '?',
            'doctrine.uuid_generator' => '?',
        ])));
        $instance->setProxyDir(($container->targetDir.''.'/doctrine/orm/Proxies'));
        $instance->setProxyNamespace('Proxies');
        $instance->setAutoGenerateProxyClasses(true);
        $instance->setSchemaIgnoreClasses([]);
        $instance->setClassMetadataFactoryName('Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ClassMetadataFactory');
        $instance->setDefaultRepositoryClassName('Doctrine\\ORM\\EntityRepository');
        $instance->setNamingStrategy(new \Doctrine\ORM\Mapping\UnderscoreNamingStrategy(0, true));
        $instance->setQuoteStrategy(new \Doctrine\ORM\Mapping\DefaultQuoteStrategy());
        $instance->setTypedFieldMapper(new \Doctrine\ORM\Mapping\DefaultTypedFieldMapper());
        $instance->setEntityListenerResolver(new \Doctrine\Bundle\DoctrineBundle\Mapping\ContainerEntityListenerResolver($container));
        $instance->setLazyGhostObjectEnabled(true);
        $instance->setIdentityGenerationPreferences([]);
        $instance->setRepositoryFactory(new \Doctrine\Bundle\DoctrineBundle\Repository\ContainerRepositoryFactory(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'App\\Repository\\AddressRepository' => ['privates', 'App\\Repository\\AddressRepository', 'getAddressRepositoryService', true],
            'App\\Repository\\DepartmentRepository' => ['privates', 'App\\Repository\\DepartmentRepository', 'getDepartmentRepositoryService', true],
            'App\\Repository\\InseeRefRepository' => ['privates', 'App\\Repository\\InseeRefRepository', 'getInseeRefRepositoryService', true],
            'App\\Repository\\LegalFormsRepository' => ['privates', 'App\\Repository\\LegalFormsRepository', 'getLegalFormsRepositoryService', true],
            'App\\Repository\\RppsPsRepository' => ['privates', 'App\\Repository\\RppsPsRepository', 'getRppsPsRepositoryService', true],
            'App\\Repository\\RppsRepository' => ['privates', 'App\\Repository\\RppsRepository', 'getRppsRepositoryService', true],
            'App\\Repository\\SpecialityRepository' => ['privates', 'App\\Repository\\SpecialityRepository', 'getSpecialityRepositoryService', true],
        ], [
            'App\\Repository\\AddressRepository' => '?',
            'App\\Repository\\DepartmentRepository' => '?',
            'App\\Repository\\InseeRefRepository' => '?',
            'App\\Repository\\LegalFormsRepository' => '?',
            'App\\Repository\\RppsPsRepository' => '?',
            'App\\Repository\\RppsRepository' => '?',
            'App\\Repository\\SpecialityRepository' => '?',
        ])));

        return $instance;
    }

    /**
     * Gets the private 'exception_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\ErrorListener
     */
    protected static function getExceptionListenerService($container)
    {
        return $container->privates['exception_listener'] = new \Symfony\Component\HttpKernel\EventListener\ErrorListener('error_controller', ($container->privates['logger'] ?? self::getLoggerService($container)), true, []);
    }

    /**
     * Gets the private 'locale_aware_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener
     */
    protected static function getLocaleAwareListenerService($container)
    {
        return $container->privates['locale_aware_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['slugger'] ??= new \Symfony\Component\String\Slugger\AsciiSlugger('en'));
        }, 1), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /**
     * Gets the private 'locale_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleListener
     */
    protected static function getLocaleListenerService($container)
    {
        return $container->privates['locale_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleListener(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), 'en', ($container->services['router'] ?? self::getRouterService($container)), false, []);
    }

    /**
     * Gets the private 'logger' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Log\Logger
     */
    protected static function getLoggerService($container)
    {
        return $container->privates['logger'] = new \Symfony\Component\HttpKernel\Log\Logger(NULL, NULL, NULL, ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), $container->getEnv('bool:default::key:web:default:kernel.runtime_mode:'));
    }

    /**
     * Gets the private 'nelmio_cors.cors_listener' shared service.
     *
     * @return \Nelmio\CorsBundle\EventListener\CorsListener
     */
    protected static function getNelmioCors_CorsListenerService($container)
    {
        return $container->privates['nelmio_cors.cors_listener'] = new \Nelmio\CorsBundle\EventListener\CorsListener(new \Nelmio\CorsBundle\Options\Resolver([new \Nelmio\CorsBundle\Options\ConfigProvider($container->parameters['nelmio_cors.map'], $container->getParameter('nelmio_cors.defaults'))]));
    }

    /**
     * Gets the private 'parameter_bag' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag
     */
    protected static function getParameterBagService($container)
    {
        return $container->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($container);
    }

    /**
     * Gets the private 'property_accessor' shared service.
     *
     * @return \Symfony\Component\PropertyAccess\PropertyAccessor
     */
    protected static function getPropertyAccessorService($container)
    {
        $a = ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());

        return $container->privates['property_accessor'] = new \Symfony\Component\PropertyAccess\PropertyAccessor(3, 2, new \Symfony\Component\Cache\Adapter\ArrayAdapter(0, false), $a, $a);
    }

    /**
     * Gets the private 'property_info' shared service.
     *
     * @return \Symfony\Component\PropertyInfo\PropertyInfoExtractor
     */
    protected static function getPropertyInfoService($container)
    {
        return $container->privates['property_info'] = new \Symfony\Component\PropertyInfo\PropertyInfoExtractor(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.serializer_extractor'] ?? $container->load('getPropertyInfo_SerializerExtractorService'));
            yield 1 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
            yield 2 => ($container->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $container->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
        }, 3), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $container->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
            yield 1 => ($container->privates['property_info.phpstan_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\PhpStanExtractor());
            yield 2 => ($container->privates['property_info.php_doc_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\PhpDocExtractor());
            yield 3 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 4), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.php_doc_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\PhpDocExtractor());
        }, 1), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $container->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
            yield 1 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 2), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 1));
    }

    /**
     * Gets the private 'router.expression_language_provider' shared service.
     *
     * @return \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider
     */
    protected static function getRouter_ExpressionLanguageProviderService($container)
    {
        return $container->privates['router.expression_language_provider'] = new \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'env' => ['privates', 'container.getenv', 'getContainer_GetenvService', true],
            'service' => ['services', 'container.get_routing_condition_service', 'getContainer_GetRoutingConditionServiceService', true],
        ], [
            'env' => 'Closure',
            'service' => 'Closure',
        ]));
    }

    /**
     * Gets the private 'router.request_context' shared service.
     *
     * @return \Symfony\Component\Routing\RequestContext
     */
    protected static function getRouter_RequestContextService($container)
    {
        $container->privates['router.request_context'] = $instance = \Symfony\Component\Routing\RequestContext::fromUri('', 'localhost', 'http', 80, 443);

        $instance->setParameter('_functions', ($container->privates['router.expression_language_provider'] ?? self::getRouter_ExpressionLanguageProviderService($container)));

        return $instance;
    }

    /**
     * Gets the private 'router_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\RouterListener
     */
    protected static function getRouterListenerService($container)
    {
        return $container->privates['router_listener'] = new \Symfony\Component\HttpKernel\EventListener\RouterListener(($container->services['router'] ?? self::getRouterService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->privates['router.request_context'] ?? self::getRouter_RequestContextService($container)), ($container->privates['logger'] ?? self::getLoggerService($container)), \dirname(__DIR__, 4), true);
    }

    /**
     * Gets the private 'security.authorization_checker' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\AuthorizationChecker
     */
    protected static function getSecurity_AuthorizationCheckerService($container)
    {
        $a = ($container->privates['debug.security.access.decision_manager'] ?? self::getDebug_Security_Access_DecisionManagerService($container));

        if (isset($container->privates['security.authorization_checker'])) {
            return $container->privates['security.authorization_checker'];
        }

        return $container->privates['security.authorization_checker'] = new \Symfony\Component\Security\Core\Authorization\AuthorizationChecker(($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), $a, false, false);
    }

    /**
     * Gets the private 'security.expression_language' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\ExpressionLanguage
     */
    protected static function getSecurity_ExpressionLanguageService($container)
    {
        $container->privates['security.expression_language'] = $instance = new \Symfony\Component\Security\Core\Authorization\ExpressionLanguage(($container->privates['cache.security_expression_language'] ?? self::getCache_SecurityExpressionLanguageService($container)));

        $instance->registerProvider(new \ApiPlatform\Symfony\Security\Core\Authorization\ExpressionLanguageProvider());

        return $instance;
    }

    /**
     * Gets the private 'security.firewall.map' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\Security\FirewallMap
     */
    protected static function getSecurity_Firewall_MapService($container)
    {
        $a = ($container->privates['.service_locator.zJyh7qS'] ?? self::get_ServiceLocator_ZJyh7qSService($container));

        if (isset($container->privates['security.firewall.map'])) {
            return $container->privates['security.firewall.map'];
        }

        return $container->privates['security.firewall.map'] = new \Symfony\Bundle\SecurityBundle\Security\FirewallMap($a, new RewindableGenerator(function () use ($container) {
            yield 'security.firewall.map.context.dev' => ($container->privates['.security.request_matcher.kLbKLHa'] ?? $container->load('get_Security_RequestMatcher_KLbKLHaService'));
            yield 'security.firewall.map.context.main' => NULL;
        }, 2));
    }

    /**
     * Gets the private 'security.logout_url_generator' shared service.
     *
     * @return \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator
     */
    protected static function getSecurity_LogoutUrlGeneratorService($container)
    {
        return $container->privates['security.logout_url_generator'] = new \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->services['router'] ?? self::getRouterService($container)), ($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)));
    }

    /**
     * Gets the private 'security.token_storage' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage
     */
    protected static function getSecurity_TokenStorageService($container)
    {
        return $container->privates['security.token_storage'] = new \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage(new \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage(), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
        ], [
            'request_stack' => '?',
        ]));
    }

    /**
     * Gets the private 'serializer' shared service.
     *
     * @return \Symfony\Component\Serializer\Serializer
     */
    protected static function getSerializerService($container)
    {
        $a = ($container->privates['api_platform.security.resource_access_checker'] ?? self::getApiPlatform_Security_ResourceAccessCheckerService($container));

        if (isset($container->privates['serializer'])) {
            return $container->privates['serializer'];
        }
        $b = ($container->privates['property_accessor'] ?? self::getPropertyAccessorService($container));
        $c = ($container->privates['property_info'] ?? self::getPropertyInfoService($container));
        $d = new \Symfony\Component\Serializer\Encoder\JsonEncoder(NULL, NULL, $container->parameters['api_platform.serializer.default_context']);

        $e = new \ApiPlatform\OpenApi\Serializer\LegacyOpenApiNormalizer(new \ApiPlatform\OpenApi\Serializer\ApiGatewayNormalizer(new \ApiPlatform\OpenApi\Serializer\OpenApiNormalizer(new \Symfony\Component\Serializer\Serializer([new \Symfony\Component\Serializer\Normalizer\ObjectNormalizer(NULL, NULL, $b, $c)], [$d]))));
        $f = ($container->privates['api_platform.hydra.name_converter.hydra_prefix'] ?? self::getApiPlatform_Hydra_NameConverter_HydraPrefixService($container));
        $g = ($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container));
        $h = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));
        $i = ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container));
        $j = ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container));
        $k = ($container->privates['api_platform.symfony.iri_converter'] ?? self::getApiPlatform_Symfony_IriConverterService($container));
        $l = ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container));
        $m = ($container->privates['api_platform.jsonld.context_builder'] ?? self::getApiPlatform_Jsonld_ContextBuilderService($container));
        $n = ($container->privates['api_platform.serializer.mapping.class_metadata_factory'] ?? self::getApiPlatform_Serializer_Mapping_ClassMetadataFactoryService($container));

        $o = new \ApiPlatform\JsonLd\Serializer\ItemNormalizer($h, $i, $j, $k, $l, $m, $b, $f, $n, $container->parameters['api_platform.serializer.default_context'], $a, NULL);

        $p = new \ApiPlatform\JsonLd\Serializer\ErrorNormalizer($o, $container->parameters['api_platform.serializer.default_context']);
        $q = new \ApiPlatform\Serializer\ItemNormalizer($i, $j, $k, $l, $b, $f, $n, NULL, $h, $a, [], NULL);
        $r = ($container->privates['serializer.name_converter.metadata_aware'] ?? self::getSerializer_NameConverter_MetadataAwareService($container));
        $s = new \Symfony\Component\Serializer\Normalizer\ObjectNormalizer($n, $r, $b, $c, new \Symfony\Component\Serializer\Mapping\ClassDiscriminatorFromClassMetadata($n), NULL, [], $c);
        $t = new \Symfony\Component\Serializer\Encoder\YamlEncoder(NULL, NULL, $container->parameters['api_platform.serializer.default_context']);

        return $container->privates['serializer'] = new \Symfony\Component\Serializer\Serializer([new \Symfony\Component\Serializer\Normalizer\UnwrappingDenormalizer($b), $e, $e, new \ApiPlatform\Serializer\ConstraintViolationListNormalizer([], $f), new \ApiPlatform\Hydra\Serializer\ConstraintViolationListNormalizer($g, [], $f, $container->parameters['api_platform.serializer.default_context']), new \ApiPlatform\Problem\Serializer\ConstraintViolationListNormalizer([], $f, $container->parameters['api_platform.serializer.default_context']), $e, new \ApiPlatform\Symfony\Validator\Serializer\ValidationExceptionNormalizer($p, $f), new \ApiPlatform\Hydra\Serializer\DocumentationNormalizer($h, $i, $j, $l, $g, $f, $container->parameters['api_platform.serializer.default_context']), new \ApiPlatform\Hydra\Serializer\EntrypointNormalizer($h, $k, $g), new \ApiPlatform\Hydra\Serializer\ErrorNormalizer($g, true, $container->parameters['api_platform.serializer.default_context']), new \ApiPlatform\Symfony\Validator\Serializer\ValidationExceptionNormalizer($q, $f), new \ApiPlatform\Problem\Serializer\ErrorNormalizer(true, []), $p, new \Symfony\Component\Serializer\Normalizer\ProblemNormalizer(true, $container->parameters['api_platform.serializer.default_context'], NULL), new \Symfony\Component\Serializer\Normalizer\UidNormalizer($container->parameters['api_platform.serializer.default_context']), $o, $q, new \Symfony\Component\Serializer\Normalizer\DateTimeNormalizer($container->parameters['api_platform.serializer.default_context']), new \Symfony\Component\Serializer\Normalizer\ConstraintViolationListNormalizer($container->parameters['api_platform.serializer.default_context'], $r), new \Symfony\Component\Serializer\Normalizer\DateTimeZoneNormalizer(), new \Symfony\Component\Serializer\Normalizer\DateIntervalNormalizer($container->parameters['api_platform.serializer.default_context']), new \Symfony\Component\Serializer\Normalizer\FormErrorNormalizer(), new \Symfony\Component\Serializer\Normalizer\BackedEnumNormalizer(), new \Symfony\Component\Serializer\Normalizer\DataUriNormalizer(NULL), new \Symfony\Component\Serializer\Normalizer\JsonSerializableNormalizer(NULL, NULL, $container->parameters['api_platform.serializer.default_context']), new \ApiPlatform\Hydra\Serializer\CollectionFiltersNormalizer(new \ApiPlatform\Hydra\Serializer\PartialCollectionViewNormalizer(new \ApiPlatform\Hydra\Serializer\CollectionNormalizer($m, $l, $k, NULL, $container->parameters['api_platform.serializer.default_context']), 'page', 'pagination', $h, $b, 1, $container->parameters['api_platform.serializer.default_context']), $h, $l, ($container->privates['api_platform.filter_locator'] ?? self::getApiPlatform_FilterLocatorService($container)), $container->parameters['api_platform.serializer.default_context']), new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), new \ApiPlatform\JsonLd\Serializer\ObjectNormalizer($s, $k, $m), $s], [new \Symfony\Component\Serializer\Encoder\XmlEncoder($container->parameters['api_platform.serializer.default_context']), $d, $t, new \Symfony\Component\Serializer\Encoder\CsvEncoder($container->parameters['api_platform.serializer.default_context']), new \ApiPlatform\Serializer\JsonEncoder('jsonopenapi', NULL), new \ApiPlatform\Serializer\YamlEncoder('yamlopenapi', $t), new \ApiPlatform\Serializer\JsonEncoder('jsonld', NULL), new \ApiPlatform\Serializer\JsonEncoder('jsonproblem')], $container->parameters['api_platform.serializer.default_context']);
    }

    /**
     * Gets the private 'serializer.name_converter.metadata_aware' shared service.
     *
     * @return \Symfony\Component\Serializer\NameConverter\MetadataAwareNameConverter
     */
    protected static function getSerializer_NameConverter_MetadataAwareService($container)
    {
        return $container->privates['serializer.name_converter.metadata_aware'] = new \Symfony\Component\Serializer\NameConverter\MetadataAwareNameConverter(($container->privates['api_platform.serializer.mapping.class_metadata_factory'] ?? self::getApiPlatform_Serializer_Mapping_ClassMetadataFactoryService($container)));
    }

    /**
     * Gets the private 'session_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\SessionListener
     */
    protected static function getSessionListenerService($container)
    {
        return $container->privates['session_listener'] = new \Symfony\Component\HttpKernel\EventListener\SessionListener(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'logger' => ['privates', 'logger', 'getLoggerService', false],
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
            'session_factory' => ['privates', 'session.factory', 'getSession_FactoryService', true],
        ], [
            'logger' => '?',
            'request_stack' => '?',
            'session_factory' => '?',
        ]), true, $container->parameters['session.storage.options']);
    }

    /**
     * Gets the private 'validator' shared service.
     *
     * @return \Symfony\Component\Validator\Validator\ValidatorInterface
     */
    protected static function getValidatorService($container)
    {
        return $container->privates['validator'] = ($container->privates['validator.builder'] ?? self::getValidator_BuilderService($container))->getValidator();
    }

    /**
     * Gets the private 'validator.builder' shared service.
     *
     * @return \Symfony\Component\Validator\ValidatorBuilder
     */
    protected static function getValidator_BuilderService($container)
    {
        $container->privates['validator.builder'] = $instance = \Symfony\Component\Validator\Validation::createValidatorBuilder();

        $a = ($container->privates['property_info'] ?? self::getPropertyInfoService($container));

        $instance->setConstraintValidatorFactory(new \Symfony\Component\Validator\ContainerConstraintValidatorFactory(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator' => ['privates', 'doctrine.orm.validator.unique', 'getDoctrine_Orm_Validator_UniqueService', true],
            'Symfony\\Component\\Security\\Core\\Validator\\Constraints\\UserPasswordValidator' => ['privates', 'security.validator.user_password', 'getSecurity_Validator_UserPasswordService', true],
            'Symfony\\Component\\Validator\\Constraints\\EmailValidator' => ['privates', 'validator.email', 'getValidator_EmailService', true],
            'Symfony\\Component\\Validator\\Constraints\\ExpressionValidator' => ['privates', 'validator.expression', 'getValidator_ExpressionService', true],
            'Symfony\\Component\\Validator\\Constraints\\NoSuspiciousCharactersValidator' => ['privates', 'validator.no_suspicious_characters', 'getValidator_NoSuspiciousCharactersService', true],
            'Symfony\\Component\\Validator\\Constraints\\NotCompromisedPasswordValidator' => ['privates', 'validator.not_compromised_password', 'getValidator_NotCompromisedPasswordService', true],
            'Symfony\\Component\\Validator\\Constraints\\WhenValidator' => ['privates', 'validator.when', 'getValidator_WhenService', true],
            'doctrine.orm.validator.unique' => ['privates', 'doctrine.orm.validator.unique', 'getDoctrine_Orm_Validator_UniqueService', true],
            'security.validator.user_password' => ['privates', 'security.validator.user_password', 'getSecurity_Validator_UserPasswordService', true],
            'validator.expression' => ['privates', 'validator.expression', 'getValidator_ExpressionService', true],
        ], [
            'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator' => '?',
            'Symfony\\Component\\Security\\Core\\Validator\\Constraints\\UserPasswordValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\EmailValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\ExpressionValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\NoSuspiciousCharactersValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\NotCompromisedPasswordValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\WhenValidator' => '?',
            'doctrine.orm.validator.unique' => '?',
            'security.validator.user_password' => '?',
            'validator.expression' => '?',
        ])));
        $instance->setGroupProviderLocator(($container->privates['.service_locator.Xbsa8iG'] ??= new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [], [])));
        $instance->setTranslationDomain('validators');
        $instance->enableAttributeMapping(true);
        $instance->addMethodMapping('loadValidatorMetadata');
        $instance->addObjectInitializers([new \Symfony\Bridge\Doctrine\Validator\DoctrineInitializer(($container->services['doctrine'] ?? self::getDoctrineService($container)))]);
        $instance->addLoader(new \Symfony\Component\Validator\Mapping\Loader\PropertyInfoLoader($a, $a, $a, NULL));
        $instance->addLoader(new \Symfony\Bridge\Doctrine\Validator\DoctrineLoader(($container->services['doctrine.orm.default_entity_manager'] ?? self::getDoctrine_Orm_DefaultEntityManagerService($container)), NULL));

        return $instance;
    }

    /**
     * Gets the private 'web_link.add_link_header_listener' shared service.
     *
     * @return \Symfony\Component\WebLink\EventListener\AddLinkHeaderListener
     */
    protected static function getWebLink_AddLinkHeaderListenerService($container)
    {
        return $container->privates['web_link.add_link_header_listener'] = new \Symfony\Component\WebLink\EventListener\AddLinkHeaderListener(($container->privates['web_link.http_header_serializer'] ??= new \Symfony\Component\WebLink\HttpHeaderSerializer()));
    }

    /**
     * Gets the private 'web_link.http_header_serializer' shared service.
     *
     * @return \Symfony\Component\WebLink\HttpHeaderSerializer
     */
    protected static function getWebLink_HttpHeaderSerializerService($container)
    {
        return $container->privates['web_link.http_header_serializer'] = new \Symfony\Component\WebLink\HttpHeaderSerializer();
    }

    public function getParameter(string $name): array|bool|string|int|float|\UnitEnum|null
    {
        if (isset($this->buildParameters[$name])) {
            return $this->buildParameters[$name];
        }

        if (!(isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters))) {
            throw new ParameterNotFoundException($name);
        }
        if (isset($this->loadedDynamicParameters[$name])) {
            return $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        }

        return $this->parameters[$name];
    }

    public function hasParameter(string $name): bool
    {
        if (isset($this->buildParameters[$name])) {
            return true;
        }

        return isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (!isset($this->parameterBag)) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            foreach ($this->buildParameters as $name => $value) {
                $parameters[$name] = $value;
            }
            $this->parameterBag = new FrozenParameterBag($parameters);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [
        'kernel.runtime_environment' => false,
        'kernel.runtime_mode' => false,
        'kernel.runtime_mode.web' => false,
        'kernel.runtime_mode.cli' => false,
        'kernel.runtime_mode.worker' => false,
        'kernel.build_dir' => false,
        'kernel.cache_dir' => false,
        'address.ban.link' => false,
        'kernel.secret' => false,
        'debug.file_link_format' => false,
        'debug.container.dump' => false,
        'router.cache_dir' => false,
        'serializer.mapping.cache.file' => false,
        'validator.mapping.cache.file' => false,
        'doctrine.orm.proxy_dir' => false,
        'nelmio_cors.defaults' => false,
    ];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        $container = $this;
        $value = match ($name) {
            'kernel.runtime_environment' => $container->getEnv('default:kernel.environment:APP_RUNTIME_ENV'),
            'kernel.runtime_mode' => $container->getEnv('query_string:default:container.runtime_mode:APP_RUNTIME_MODE'),
            'kernel.runtime_mode.web' => $container->getEnv('bool:default::key:web:default:kernel.runtime_mode:'),
            'kernel.runtime_mode.cli' => $container->getEnv('not:default:kernel.runtime_mode.web:'),
            'kernel.runtime_mode.worker' => $container->getEnv('bool:default::key:worker:default:kernel.runtime_mode:'),
            'kernel.build_dir' => $container->targetDir.'',
            'kernel.cache_dir' => $container->targetDir.'',
            'address.ban.link' => $container->getEnv('BAN_ADDRESS_URL'),
            'kernel.secret' => $container->getEnv('APP_SECRET'),
            'debug.file_link_format' => $container->getEnv('default::SYMFONY_IDE'),
            'debug.container.dump' => ($container->targetDir.''.'/App_KernelDevDebugContainer.xml'),
            'router.cache_dir' => $container->targetDir.'',
            'serializer.mapping.cache.file' => ($container->targetDir.''.'/serialization.php'),
            'validator.mapping.cache.file' => ($container->targetDir.''.'/validation.php'),
            'doctrine.orm.proxy_dir' => ($container->targetDir.''.'/doctrine/orm/Proxies'),
            'nelmio_cors.defaults' => [
                'allow_origin' => [
                    0 => $container->getEnv('CORS_ALLOW_ORIGIN'),
                ],
                'allow_credentials' => false,
                'allow_headers' => [
                    0 => 'content-type',
                    1 => 'authorization',
                ],
                'allow_private_network' => false,
                'expose_headers' => [
                    0 => 'Link',
                ],
                'allow_methods' => [
                    0 => 'GET',
                    1 => 'OPTIONS',
                    2 => 'POST',
                    3 => 'PUT',
                    4 => 'PATCH',
                    5 => 'DELETE',
                ],
                'max_age' => 3600,
                'hosts' => [

                ],
                'origin_regex' => true,
                'skip_same_as_origin' => true,
                'forced_allow_origin_value' => NULL,
            ],
            default => throw new ParameterNotFoundException($name),
        };
        $this->loadedDynamicParameters[$name] = true;

        return $this->dynamicParameters[$name] = $value;
    }

    protected function getDefaultParameters(): array
    {
        return [
            'kernel.project_dir' => \dirname(__DIR__, 4),
            'kernel.environment' => 'dev',
            'kernel.debug' => true,
            'kernel.logs_dir' => (\dirname(__DIR__, 3).'/log'),
            'kernel.bundles' => [
                'FrameworkBundle' => 'Symfony\\Bundle\\FrameworkBundle\\FrameworkBundle',
                'TwigBundle' => 'Symfony\\Bundle\\TwigBundle\\TwigBundle',
                'SecurityBundle' => 'Symfony\\Bundle\\SecurityBundle\\SecurityBundle',
                'DoctrineBundle' => 'Doctrine\\Bundle\\DoctrineBundle\\DoctrineBundle',
                'DoctrineMigrationsBundle' => 'Doctrine\\Bundle\\MigrationsBundle\\DoctrineMigrationsBundle',
                'NelmioCorsBundle' => 'Nelmio\\CorsBundle\\NelmioCorsBundle',
                'ApiPlatformBundle' => 'ApiPlatform\\Symfony\\Bundle\\ApiPlatformBundle',
                'MakerBundle' => 'Symfony\\Bundle\\MakerBundle\\MakerBundle',
            ],
            'kernel.bundles_metadata' => [
                'FrameworkBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/framework-bundle'),
                    'namespace' => 'Symfony\\Bundle\\FrameworkBundle',
                ],
                'TwigBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/twig-bundle'),
                    'namespace' => 'Symfony\\Bundle\\TwigBundle',
                ],
                'SecurityBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/security-bundle'),
                    'namespace' => 'Symfony\\Bundle\\SecurityBundle',
                ],
                'DoctrineBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\DoctrineBundle',
                ],
                'DoctrineMigrationsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-migrations-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\MigrationsBundle',
                ],
                'NelmioCorsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle'),
                    'namespace' => 'Nelmio\\CorsBundle',
                ],
                'ApiPlatformBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/api-platform/core/src/Symfony/Bundle'),
                    'namespace' => 'ApiPlatform\\Symfony\\Bundle',
                ],
                'MakerBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/maker-bundle'),
                    'namespace' => 'Symfony\\Bundle\\MakerBundle',
                ],
            ],
            'kernel.charset' => 'UTF-8',
            'kernel.container_class' => 'App_KernelDevDebugContainer',
            'address.csv.path' => 'public/downloads/addresses/adresses-with-ids-france.csv',
            'log.path' => 'var/log/update_rpps_address.log',
            'event_dispatcher.event_aliases' => [
                'Symfony\\Component\\Console\\Event\\ConsoleCommandEvent' => 'console.command',
                'Symfony\\Component\\Console\\Event\\ConsoleErrorEvent' => 'console.error',
                'Symfony\\Component\\Console\\Event\\ConsoleSignalEvent' => 'console.signal',
                'Symfony\\Component\\Console\\Event\\ConsoleTerminateEvent' => 'console.terminate',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerArgumentsEvent' => 'kernel.controller_arguments',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerEvent' => 'kernel.controller',
                'Symfony\\Component\\HttpKernel\\Event\\ResponseEvent' => 'kernel.response',
                'Symfony\\Component\\HttpKernel\\Event\\FinishRequestEvent' => 'kernel.finish_request',
                'Symfony\\Component\\HttpKernel\\Event\\RequestEvent' => 'kernel.request',
                'Symfony\\Component\\HttpKernel\\Event\\ViewEvent' => 'kernel.view',
                'Symfony\\Component\\HttpKernel\\Event\\ExceptionEvent' => 'kernel.exception',
                'Symfony\\Component\\HttpKernel\\Event\\TerminateEvent' => 'kernel.terminate',
                'Symfony\\Component\\Security\\Core\\Event\\AuthenticationSuccessEvent' => 'security.authentication.success',
                'Symfony\\Component\\Security\\Http\\Event\\InteractiveLoginEvent' => 'security.interactive_login',
                'Symfony\\Component\\Security\\Http\\Event\\SwitchUserEvent' => 'security.switch_user',
            ],
            'fragment.renderer.hinclude.global_template' => NULL,
            'fragment.path' => '/_fragment',
            'kernel.http_method_override' => false,
            'kernel.trust_x_sendfile_type_header' => false,
            'kernel.trusted_hosts' => [

            ],
            'kernel.default_locale' => 'en',
            'kernel.enabled_locales' => [

            ],
            'kernel.error_controller' => 'error_controller',
            'asset.request_context.base_path' => NULL,
            'asset.request_context.secure' => NULL,
            'debug.error_handler.throw_at' => -1,
            'router.request_context.host' => 'localhost',
            'router.request_context.scheme' => 'http',
            'router.request_context.base_url' => '',
            'router.resource' => 'kernel::loadRoutes',
            'request_listener.http_port' => 80,
            'request_listener.https_port' => 443,
            'session.metadata.storage_key' => '_sf2_meta',
            'session.storage.options' => [
                'cache_limiter' => '0',
                'cookie_secure' => 'auto',
                'cookie_httponly' => true,
                'cookie_samesite' => 'lax',
                'gc_probability' => 1,
            ],
            'session.save_path' => NULL,
            'session.metadata.update_threshold' => 0,
            'validator.translation_domain' => 'validators',
            'data_collector.templates' => [

            ],
            'twig.form.resources' => [
                0 => 'form_div_layout.html.twig',
            ],
            'twig.default_path' => (\dirname(__DIR__, 4).'/templates'),
            'security.role_hierarchy.roles' => [

            ],
            'security.access.denied_url' => NULL,
            'security.authentication.manager.erase_credentials' => true,
            'security.authentication.session_strategy.strategy' => 'migrate',
            'security.authentication.hide_user_not_found' => true,
            'security.firewalls' => [
                0 => 'dev',
                1 => 'main',
            ],
            'security.logout_uris' => [

            ],
            'doctrine.dbal.configuration.class' => 'Doctrine\\DBAL\\Configuration',
            'doctrine.data_collector.class' => 'Doctrine\\Bundle\\DoctrineBundle\\DataCollector\\DoctrineDataCollector',
            'doctrine.dbal.connection.event_manager.class' => 'Symfony\\Bridge\\Doctrine\\ContainerAwareEventManager',
            'doctrine.dbal.connection_factory.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ConnectionFactory',
            'doctrine.dbal.events.mysql_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\MysqlSessionInit',
            'doctrine.dbal.events.oracle_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\OracleSessionInit',
            'doctrine.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Registry',
            'doctrine.entity_managers' => [
                'default' => 'doctrine.orm.default_entity_manager',
            ],
            'doctrine.default_entity_manager' => 'default',
            'doctrine.dbal.connection_factory.types' => [

            ],
            'doctrine.connections' => [
                'default' => 'doctrine.dbal.default_connection',
            ],
            'doctrine.default_connection' => 'default',
            'doctrine.orm.configuration.class' => 'Doctrine\\ORM\\Configuration',
            'doctrine.orm.entity_manager.class' => 'Doctrine\\ORM\\EntityManager',
            'doctrine.orm.manager_configurator.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ManagerConfigurator',
            'doctrine.orm.cache.array.class' => 'Doctrine\\Common\\Cache\\ArrayCache',
            'doctrine.orm.cache.apc.class' => 'Doctrine\\Common\\Cache\\ApcCache',
            'doctrine.orm.cache.memcache.class' => 'Doctrine\\Common\\Cache\\MemcacheCache',
            'doctrine.orm.cache.memcache_host' => 'localhost',
            'doctrine.orm.cache.memcache_port' => 11211,
            'doctrine.orm.cache.memcache_instance.class' => 'Memcache',
            'doctrine.orm.cache.memcached.class' => 'Doctrine\\Common\\Cache\\MemcachedCache',
            'doctrine.orm.cache.memcached_host' => 'localhost',
            'doctrine.orm.cache.memcached_port' => 11211,
            'doctrine.orm.cache.memcached_instance.class' => 'Memcached',
            'doctrine.orm.cache.redis.class' => 'Doctrine\\Common\\Cache\\RedisCache',
            'doctrine.orm.cache.redis_host' => 'localhost',
            'doctrine.orm.cache.redis_port' => 6379,
            'doctrine.orm.cache.redis_instance.class' => 'Redis',
            'doctrine.orm.cache.xcache.class' => 'Doctrine\\Common\\Cache\\XcacheCache',
            'doctrine.orm.cache.wincache.class' => 'Doctrine\\Common\\Cache\\WinCacheCache',
            'doctrine.orm.cache.zenddata.class' => 'Doctrine\\Common\\Cache\\ZendDataCache',
            'doctrine.orm.metadata.driver_chain.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\MappingDriverChain',
            'doctrine.orm.metadata.annotation.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AnnotationDriver',
            'doctrine.orm.metadata.xml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedXmlDriver',
            'doctrine.orm.metadata.yml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedYamlDriver',
            'doctrine.orm.metadata.php.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\PHPDriver',
            'doctrine.orm.metadata.staticphp.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\StaticPHPDriver',
            'doctrine.orm.metadata.attribute.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AttributeDriver',
            'doctrine.orm.proxy_cache_warmer.class' => 'Symfony\\Bridge\\Doctrine\\CacheWarmer\\ProxyCacheWarmer',
            'form.type_guesser.doctrine.class' => 'Symfony\\Bridge\\Doctrine\\Form\\DoctrineOrmTypeGuesser',
            'doctrine.orm.validator.unique.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator',
            'doctrine.orm.validator_initializer.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\DoctrineInitializer',
            'doctrine.orm.security.user.provider.class' => 'Symfony\\Bridge\\Doctrine\\Security\\User\\EntityUserProvider',
            'doctrine.orm.listeners.resolve_target_entity.class' => 'Doctrine\\ORM\\Tools\\ResolveTargetEntityListener',
            'doctrine.orm.listeners.attach_entity_listeners.class' => 'Doctrine\\ORM\\Tools\\AttachEntityListenersListener',
            'doctrine.orm.naming_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultNamingStrategy',
            'doctrine.orm.naming_strategy.underscore.class' => 'Doctrine\\ORM\\Mapping\\UnderscoreNamingStrategy',
            'doctrine.orm.quote_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultQuoteStrategy',
            'doctrine.orm.quote_strategy.ansi.class' => 'Doctrine\\ORM\\Mapping\\AnsiQuoteStrategy',
            'doctrine.orm.typed_field_mapper.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultTypedFieldMapper',
            'doctrine.orm.entity_listener_resolver.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ContainerEntityListenerResolver',
            'doctrine.orm.second_level_cache.default_cache_factory.class' => 'Doctrine\\ORM\\Cache\\DefaultCacheFactory',
            'doctrine.orm.second_level_cache.default_region.class' => 'Doctrine\\ORM\\Cache\\Region\\DefaultRegion',
            'doctrine.orm.second_level_cache.filelock_region.class' => 'Doctrine\\ORM\\Cache\\Region\\FileLockRegion',
            'doctrine.orm.second_level_cache.logger_chain.class' => 'Doctrine\\ORM\\Cache\\Logging\\CacheLoggerChain',
            'doctrine.orm.second_level_cache.logger_statistics.class' => 'Doctrine\\ORM\\Cache\\Logging\\StatisticsCacheLogger',
            'doctrine.orm.second_level_cache.cache_configuration.class' => 'Doctrine\\ORM\\Cache\\CacheConfiguration',
            'doctrine.orm.second_level_cache.regions_configuration.class' => 'Doctrine\\ORM\\Cache\\RegionsConfiguration',
            'doctrine.orm.auto_generate_proxy_classes' => true,
            'doctrine.orm.enable_lazy_ghost_objects' => true,
            'doctrine.orm.enable_native_lazy_objects' => false,
            'doctrine.orm.proxy_namespace' => 'Proxies',
            'doctrine.migrations.preferred_em' => NULL,
            'doctrine.migrations.preferred_connection' => NULL,
            'nelmio_cors.map' => [
                '^/' => [

                ],
            ],
            'nelmio_cors.cors_listener.class' => 'Nelmio\\CorsBundle\\EventListener\\CorsListener',
            'nelmio_cors.options_resolver.class' => 'Nelmio\\CorsBundle\\Options\\Resolver',
            'nelmio_cors.options_provider.config.class' => 'Nelmio\\CorsBundle\\Options\\ConfigProvider',
            'api_platform.use_symfony_listeners' => true,
            'api_platform.event_listeners_backward_compatibility_layer' => NULL,
            'api_platform.serializer.default_context' => [
                'hydra_prefix' => true,
            ],
            'api_platform.enable_entrypoint' => true,
            'api_platform.enable_docs' => true,
            'api_platform.keep_legacy_inflector' => false,
            'api_platform.title' => 'Hello API Platform',
            'api_platform.description' => '',
            'api_platform.version' => '1.0.0',
            'api_platform.show_webby' => true,
            'api_platform.url_generation_strategy' => 1,
            'api_platform.exception_to_status' => [
                'Symfony\\Component\\Serializer\\Exception\\ExceptionInterface' => 400,
                'ApiPlatform\\Metadata\\Exception\\InvalidArgumentException' => 400,
                'ApiPlatform\\ParameterValidator\\Exception\\ValidationExceptionInterface' => 400,
                'Doctrine\\ORM\\OptimisticLockException' => 409,
            ],
            'api_platform.formats' => [
                'jsonld' => [
                    0 => 'application/ld+json',
                ],
                'json' => [
                    0 => 'application/json',
                ],
            ],
            'api_platform.patch_formats' => [
                'json' => [
                    0 => 'application/merge-patch+json',
                ],
            ],
            'api_platform.error_formats' => [
                'jsonld' => [
                    0 => 'application/ld+json',
                ],
                'jsonproblem' => [
                    0 => 'application/problem+json',
                ],
                'json' => [
                    0 => 'application/problem+json',
                    1 => 'application/json',
                ],
            ],
            'api_platform.docs_formats' => [
                'jsonopenapi' => [
                    0 => 'application/vnd.openapi+json',
                ],
                'yamlopenapi' => [
                    0 => 'application/vnd.openapi+yaml',
                ],
                'json' => [
                    0 => 'application/json',
                ],
                'jsonld' => [
                    0 => 'application/ld+json',
                ],
                'html' => [
                    0 => 'text/html',
                ],
            ],
            'api_platform.jsonschema_formats' => [
                'jsonld' => true,
                'json' => true,
            ],
            'api_platform.eager_loading.enabled' => true,
            'api_platform.eager_loading.max_joins' => 30,
            'api_platform.eager_loading.fetch_partial' => false,
            'api_platform.eager_loading.force_eager' => true,
            'api_platform.collection.exists_parameter_name' => 'exists',
            'api_platform.collection.order' => 'ASC',
            'api_platform.collection.order_parameter_name' => 'order',
            'api_platform.collection.order_nulls_comparison' => NULL,
            'api_platform.collection.pagination.enabled' => true,
            'api_platform.collection.pagination.partial' => false,
            'api_platform.collection.pagination.client_enabled' => false,
            'api_platform.collection.pagination.client_items_per_page' => false,
            'api_platform.collection.pagination.client_partial' => false,
            'api_platform.collection.pagination.items_per_page' => 30,
            'api_platform.collection.pagination.maximum_items_per_page' => NULL,
            'api_platform.collection.pagination.page_parameter_name' => 'page',
            'api_platform.collection.pagination.enabled_parameter_name' => 'pagination',
            'api_platform.collection.pagination.items_per_page_parameter_name' => 'itemsPerPage',
            'api_platform.collection.pagination.partial_parameter_name' => 'partial',
            'api_platform.collection.pagination' => [
                'enabled' => true,
                'page_parameter_name' => 'page',
                'enabled_parameter_name' => 'pagination',
                'items_per_page_parameter_name' => 'itemsPerPage',
                'partial_parameter_name' => 'partial',
            ],
            'api_platform.handle_symfony_errors' => false,
            'api_platform.http_cache.etag' => true,
            'api_platform.http_cache.max_age' => NULL,
            'api_platform.http_cache.shared_max_age' => NULL,
            'api_platform.http_cache.vary' => [
                0 => 'Content-Type',
                1 => 'Authorization',
                2 => 'Origin',
            ],
            'api_platform.http_cache.public' => NULL,
            'api_platform.http_cache.invalidation.max_header_length' => 7500,
            'api_platform.http_cache.invalidation.xkey.glue' => ' ',
            'api_platform.asset_package' => NULL,
            'api_platform.defaults' => [
                'extra_properties' => [
                    'standard_put' => true,
                    'rfc_7807_compliant_errors' => true,
                ],
                'stateless' => true,
                'cache_headers' => [
                    'vary' => [
                        0 => 'Content-Type',
                        1 => 'Authorization',
                        2 => 'Origin',
                    ],
                ],
            ],
            'api_platform.rfc_7807_compliant_errors' => true,
            'api_platform.resource_class_directories' => [
                0 => (\dirname(__DIR__, 4).'/src/ApiResource'),
                1 => (\dirname(__DIR__, 4).'/src/Entity'),
            ],
            'api_platform.class_name_resources' => [
                0 => 'ApiPlatform\\State\\ApiResource\\Error',
                1 => 'ApiPlatform\\Symfony\\Validator\\Exception\\ValidationException',
                2 => 'ApiPlatform\\Validator\\Exception\\ValidationException',
            ],
            'api_platform.oauth.enabled' => false,
            'api_platform.oauth.clientId' => '',
            'api_platform.oauth.clientSecret' => '',
            'api_platform.oauth.type' => 'oauth2',
            'api_platform.oauth.flow' => 'application',
            'api_platform.oauth.tokenUrl' => '',
            'api_platform.oauth.authorizationUrl' => '',
            'api_platform.oauth.refreshUrl' => '',
            'api_platform.oauth.scopes' => [

            ],
            'api_platform.oauth.pkce' => false,
            'api_platform.openapi.termsOfService' => NULL,
            'api_platform.openapi.contact.name' => NULL,
            'api_platform.openapi.contact.url' => NULL,
            'api_platform.openapi.contact.email' => NULL,
            'api_platform.openapi.license.name' => NULL,
            'api_platform.openapi.license.url' => NULL,
            'api_platform.openapi.overrideResponses' => true,
            'api_platform.swagger.versions' => [
                0 => 3,
            ],
            'api_platform.enable_swagger_ui' => true,
            'api_platform.enable_re_doc' => true,
            'api_platform.swagger.api_keys' => [

            ],
            'api_platform.swagger_ui.extra_configuration' => [

            ],
            'api_platform.graphql.enabled' => false,
            'api_platform.graphql.introspection.enabled' => false,
            'api_platform.graphql.graphiql.enabled' => false,
            'api_platform.graphql.graphql_playground.enabled' => false,
            'api_platform.graphql.collection.pagination' => [
                'enabled' => true,
            ],
            'api_platform.validator.legacy_validation_exception' => true,
            'api_platform.validator.serialize_payload_fields' => [

            ],
            'api_platform.validator.query_parameter_validation' => true,
            'api_platform.elasticsearch.enabled' => false,
            'console.command.ids' => [

            ],
        ];
    }
}
